<?php
	class Lipisha {
		
		// api call
		var $api_base;
		var $api_endpoint;
		var $api_parameters;
		
		// api parameters
		var $api_environment;
		var $api_key;
		var $api_signature;

		// response
		var $status;
		var $status_code;	
		var $status_description;	
		var $json;	
		
		public function __construct($api_key="", $api_signature="", $api_environment = "")
		{
			$this->api_base = "";
			$this->api_endpoint = "";
			$this->api_parameters = "";	

			$this->api_key = $api_key;
			$this->api_signature = $api_signature;		
			$this->api_environment = $api_environment;		
			
			$this->status = "";	
			$this->status_code = "";	
			$this->status_description = "";	
			$this->json = "";	
		}	
			
		function execute()
		{		
			
			$this->api_base = "http://developer.lipisha.com/index.php/v2/api/";

			if (strtoupper($this->api_environment) == strtoupper("live"))
			{
				$this->api_base = "https://www.lipisha.com/payments/accounts/index.php/v2/api/";
			}

			$this->api_url = $this->api_base . $this->api_endpoint; 
			
			$this->api_parameters = 'api_key=' . urlencode($this->api_key) . '&api_signature=' . urlencode($this->api_signature) . $this->api_parameters;	
			
			// execute post
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $this->api_url);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $this->api_parameters); 
			curl_setopt($ch, CURLOPT_TIMEOUT, 180);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  2);
			$results = curl_exec($ch);
			curl_close($ch);
						
			// process json
			$results = trim($results);
			$response = json_decode($results, TRUE);
			
			$this->status = urldecode($response["status"]["status"]);
			$this->status_code = urldecode($response["status"]["status_code"]);
			$this->status_description = urldecode($response["status"]["status_description"]);
			$this->content =$response["content"];
			$this->json = urldecode($results);
		}

		public function get_transactions($transaction="", $transaction_type="",$transaction_method="", $transaction_date_start="", $transaction_date_end="",$transaction_account_name="", $transaction_account_number="",$transaction_reference="", $transaction_amount_minimum="",$transaction_amount_maximum="", $transaction_status="",$transaction_name="", $transaction_mobile_number="", $transaction_email="", $limit=1000, $offset=0)
		{
			$this->api_endpoint = "get_transactions";	
			$this->api_parameters  = '&transaction=' . urlencode($transaction);
			$this->api_parameters .= '&transaction_type=' . urlencode($transaction_type);
			$this->api_parameters .= '&transaction_method=' . urlencode($transaction_method);
			$this->api_parameters .= '&transaction_date_start=' . urlencode($transaction_date_start);
			$this->api_parameters .= '&transaction_date_end=' . urlencode($transaction_date_end);
			$this->api_parameters .= '&transaction_account_name=' . urlencode($transaction_account_name);
			$this->api_parameters .= '&transaction_account_number=' . urlencode($transaction_account_number);
			$this->api_parameters .= '&transaction_reference=' . urlencode($transaction_reference);
			$this->api_parameters .= '&transaction_amount_minimum=' . urlencode($transaction_amount_minimum);
			$this->api_parameters .= '&transaction_amount_maximum=' . urlencode($transaction_amount_maximum);
			$this->api_parameters .= '&transaction_status=' . urlencode($transaction_status);
			$this->api_parameters .= '&transaction_name=' . urlencode($transaction_name);
			$this->api_parameters .= '&transaction_mobile_number=' . urlencode($transaction_mobile_number);
			$this->api_parameters .= '&transaction_email=' . urlencode($transaction_email);
			$this->api_parameters .= '&limit=' . urlencode($limit);
			$this->api_parameters .= '&offset=' . urlencode($offset);
			$this->execute();
		}

		public function get_customers($customer_name="", $customer_mobile_number="",$customer_email="", $customer_first_payment_from="", $customer_first_payment_to="",$customer_last_payment_from="", $customer_last_payment_to="",$customer_payments_minimum="", $customer_payments_maximum="",$customer_total_spent_minimum="", $customer_total_spent_maximum="",$customer_average_spent_minimum="", $customer_average_spent_maximum="", $limit=1000, $offset=0)
		{	
			$this->api_endpoint = "get_customers";	
			$this->api_parameters  = '&customer_name=' . urlencode($customer_name);
			$this->api_parameters .= '&customer_mobile_number=' . urlencode($customer_mobile_number);
			$this->api_parameters .= '&customer_email=' . urlencode($customer_email);
			$this->api_parameters .= '&customer_first_payment_from=' . urlencode($customer_first_payment_from);
			$this->api_parameters .= '&customer_first_payment_to=' . urlencode($customer_first_payment_to);
			$this->api_parameters .= '&customer_last_payment_from=' . urlencode($customer_last_payment_from);
			$this->api_parameters .= '&customer_last_payment_to=' . urlencode($customer_last_payment_to);
			$this->api_parameters .= '&customer_payments_minimum=' . urlencode($customer_payments_minimum);
			$this->api_parameters .= '&customer_payments_maximum=' . urlencode($customer_payments_maximum);
			$this->api_parameters .= '&customer_total_spent_minimum=' . urlencode($customer_total_spent_minimum);
			$this->api_parameters .= '&customer_total_spent_maximum=' . urlencode($customer_total_spent_maximum);
			$this->api_parameters .= '&customer_average_spent_minimum=' . urlencode($customer_average_spent_minimum);
			$this->api_parameters .= '&customer_average_spent_maximum=' . urlencode($customer_average_spent_maximum);
			$this->api_parameters .= '&limit=' . urlencode($limit);
			$this->api_parameters .= '&offset=' . urlencode($offset);
			$this->execute();
		}

		public function create_payment_account($transaction_account_type, $transaction_account_name, $transaction_account_manager)
		{
			$this->api_endpoint = "create_payment_account";	
			$this->api_parameters  = '&transaction_account_type=' . urlencode($transaction_account_type);
			$this->api_parameters .= '&transaction_account_name=' . urlencode($transaction_account_name);
			$this->api_parameters .= '&transaction_account_manager=' . urlencode($transaction_account_manager);
			$this->execute();
		}


		public function create_user($full_name, $role, $mobile_number, $email, $user_name, $password)
		{
			$this->api_endpoint = "create_user";	
			$this->api_parameters  = '&full_name=' . urlencode($full_name);
			$this->api_parameters .= '&role=' . urlencode($role);
			$this->api_parameters .= '&mobile_number=' . urlencode($mobile_number);
			$this->api_parameters .= '&email=' . urlencode($email);
			$this->api_parameters .= '&user_name=' . urlencode($user_name);
			$this->api_parameters .= '&password=' . urlencode($password);
			$this->execute();
		}

		public function create_withdrawal_account($transaction_account_type, $transaction_account_name, $transaction_account_number, $transaction_account_bank_name,  $transaction_account_bank_branch,  $transaction_account_bank_address,  $transaction_account_swift_code, $transaction_account_manager)
		{
			$this->api_endpoint = "create_withdrawal_account";	
			$this->api_parameters  = '&transaction_account_type=' . urlencode($transaction_account_type);
			$this->api_parameters .= '&transaction_account_name=' . urlencode($transaction_account_name);
			$this->api_parameters .= '&transaction_account_number=' . urlencode($transaction_account_number);
			$this->api_parameters .= '&transaction_account_bank_name=' . urlencode($transaction_account_bank_name);
			$this->api_parameters .= '&transaction_account_bank_branch=' . urlencode($transaction_account_bank_branch);
			$this->api_parameters .= '&transaction_account_bank_address=' . urlencode($transaction_account_bank_address);
			$this->api_parameters .= '&transaction_account_swift_code=' . urlencode($transaction_account_swift_code);
			$this->api_parameters .= '&transaction_account_manager=' . urlencode($transaction_account_manager);
			$this->execute();
		}

		public function acknowledge_transaction($transaction)
		{
			$this->api_endpoint = "acknowledge_transaction";	
			$this->api_parameters = '&transaction=' . urlencode($transaction);
			$this->execute();
		}

		public function confirm_transaction($transaction)
		{
			$this->api_endpoint = "confirm_transaction";	
			$this->api_parameters = '&transaction=' . urlencode($transaction);
			$this->execute();
		}
		
		public function reverse_transaction($transaction)
		{
			$this->api_endpoint = "reverse_transaction";	
			$this->api_parameters = '&transaction=' . urlencode($transaction);
			$this->execute();
		}
				
		public function send_money($account_number, $mobile_number, $amount)
		{
			$this->api_endpoint = "send_money";	
			$this->api_parameters  = '&account_number=' . urlencode($account_number);
			$this->api_parameters .= '&mobile_number=' . urlencode($mobile_number);
			$this->api_parameters .= '&amount=' . urlencode($amount);
			$this->execute();
		}		

		public function send_airtime($account_number, $mobile_number, $amount, $mobile_network)
		{
			$this->api_endpoint = "send_airtime";	
			$this->api_parameters  = '&account_number=' . urlencode($account_number);
			$this->api_parameters .= '&mobile_number=' . urlencode($mobile_number);
			$this->api_parameters .= '&mobile_network=' . urlencode($mobile_network);
			$this->api_parameters .= '&amount=' . urlencode($amount);
			$this->execute();
		}		

		public function get_float($account_number)
		{
			$this->api_endpoint = "get_float";	
			$this->api_parameters = '&account_number=' . urlencode($account_number);
			$this->execute();
		}

		public function get_balance()
		{
			$this->api_endpoint = "get_balance";	
			$this->api_parameters = '';
			$this->execute();
		}		

		public function authorize_card_transaction($account_number="", $name="", $email="", $mobile_number="",$address1="", $address2="", $country="",$state="", $zip="",$card_number="", $expiry="",$security_code="", $amount="",$currency="")
		{
			$this->api_endpoint = "authorize_card_transaction";	
			$this->api_parameters  = '&account_number=' . urlencode($account_number);
			$this->api_parameters .= '&name=' . urlencode($name);
			$this->api_parameters .= '&email=' . urlencode($email);
			$this->api_parameters .= '&mobile_number=' . urlencode($mobile_number);
			$this->api_parameters .= '&address1=' . urlencode($address1);
			$this->api_parameters .= '&address2=' . urlencode($address2);
			$this->api_parameters .= '&country=' . urlencode($country);
			$this->api_parameters .= '&state=' . urlencode($state);
			$this->api_parameters .= '&zip=' . urlencode($zip);
			$this->api_parameters .= '&card_number=' . urlencode($card_number);
			$this->api_parameters .= '&expiry=' . urlencode($expiry);
			$this->api_parameters .= '&security_code=' . urlencode($security_code);
			$this->api_parameters .= '&amount=' . urlencode($amount);
			$this->api_parameters .= '&currency=' . urlencode($currency);
			$this->execute();
		}

		public function complete_card_transaction($transaction_index="", $transaction_reference="")
		{
			$this->api_endpoint = "complete_card_transaction";	
			$this->api_parameters  = '&transaction_index=' . urlencode($transaction_index);
			$this->api_parameters .= '&transaction_reference=' . urlencode($transaction_reference);
			$this->execute();
		}

		public function reverse_card_authorization($transaction_index="", $transaction_reference="")
		{
			$this->api_endpoint = "reverse_card_authorization";	
			$this->api_parameters  = '&transaction_index=' . urlencode($transaction_index);
			$this->api_parameters .= '&transaction_reference=' . urlencode($transaction_reference);
			$this->execute();
		}

		public function void_card_transaction($transaction_index="", $transaction_reference="")
		{
			$this->api_endpoint = "void_card_transaction";	
			$this->api_parameters  = '&transaction_index=' . urlencode($transaction_index);
			$this->api_parameters .= '&transaction_reference=' . urlencode($transaction_reference);
			$this->execute();
		}
		
	}
?>