<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_management extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->library('form_validation');
		$this->login_model->authenticate();
		$this->load->model('user_management_model');
		$corporation_id = $this->login_model->corp_id();
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();	
	}
	 
	 
	public function member_registration()
	{	
		$this->load->view('sections/topbar');
		$this->load->view('sections/sidebar');
		$this->load->view('sections/breadcrumb');
		$this->load->view('user_management/member_registration');
		$this->load->view('sections/footer');
	}
	
	public function next_of_kin()
	{	
		$this->load->view('sections/topbar');
		$this->load->view('sections/sidebar');
		$this->load->view('sections/breadcrumb');
		$this->load->view('user_management/next_of_kin');
		$this->load->view('sections/footer');
	}
	
	private function upload_profile_pic()
	{
		$config['upload_path'] = 'images/profile_photos';
		$config['allowed_types'] = 'jpg|png|jpeg';
		$config['file_name'] = $_POST['national_id_no'].'_'.time();
		
		$this->load->library('upload',$config);
		
		if(!$this->upload->do_upload())
			{
				$error = array('error' =>$this->upload->display_errors());
				//$this->load->view('user_management/user_profile_view',$error);
				return 'default_image.jpg';
			}
			else
			{
				$datas = array('upload_data' => $this->upload->data());
				//print_r($datas);
				foreach($datas as $key => $val)
				{
					return $val['file_name'];
				}	
			}
	} 
	
	public function view_members()
	{
		$members = $this->main_model->get_all_data('users');
		$data = array('members' => $members);
		
		$this->load->view('sections/topbar');
		$this->load->view('sections/sidebar');
		$this->load->view('sections/breadcrumb');
		$this->load->view('user_management/view_members',$data);
		$this->load->view('sections/footer');
	
	}

	public function user_profile($user_id)
	{
		$data['row'] = $this->user_management_model->fetch_user_data($user_id);
		//$data = array('member_details' => $member_details);
		
		$this->load->view('sections/topbar');
		$this->load->view('sections/sidebar');
		$this->load->view('sections/breadcrumb');
		$this->load->view('user_management/user_profile_view',$data);
		$this->load->view('sections/footer');
	
	}
	
	function create_thumbnail($image)
	{
		$config['image_library'] = 'gd2';
		$config['source_image']	= '/images/profile_photos/'.$image;
		$config['maintain_ratio'] = TRUE;
		$config['width']	= 165;
		$config['height']	= 165;
		
		$this->load->library('image_lib', $config); 
		
		$this->image_lib->resize();	
	}
	
	//this function adds/inserts the details of a member into the database	
	 public function insert_member_details()
	  {	  
	      global $corporation_id, $user_type;		  
		  
		  $this->form_validation->set_rules('member_no', 'Member Number', 'required|is_numeric');
		  $this->form_validation->set_rules('email_address', 'Email Address', 'valid_email');
		  $this->form_validation->set_rules('first_name', 'First Name', 'required|alpha');			
		  $this->form_validation->set_rules('phone_no','Phone Number', 'required|numeric');						
		  $this->form_validation->set_rules('other_names', 'Other Names', 'required');					
		  $this->form_validation->set_rules('national_id_no', 'National ID NO', 'required|is_numeric');
		  $this->password = md5(strtolower($this->input->post('first_name')));
			  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->member_registration();		  
		  }
		  else // passed validation proceed to post success logic
		  {
			 // build array for the model			 
			$file_name =$this->upload_profile_pic();
				
			  $form_data = array(
							  'member_no' => $this->input->post('member_no'),
							  'email_address' => $this->input->post('email_address'),
							  'first_name' => $this->input->post('first_name'),
							  'phone_no' => $this->input->post('phone_no'),
							  'other_names' => $this->input->post('other_names'),
							  'name' =>$this->input->post('first_name').$this->input->post('other_names'),
							  'national_id_no' => $this->input->post('national_id_no'),
							  'corporation_id' => $this->corporation_id,
							  'user_type' => $this->user_type,
							  'date_created' => time(),
							  'password' => $this->password,
							  'photo' => $file_name							  
						  );
			  $table = 'users';	
			  $this->main_model->insert_data($table, $form_data);
			  
			  $insert_id = $this->db->insert_id();					 				  
			  redirect('user_management/user_profile/'.($insert_id));						  
		  }		
	  }
	  
	  public function insert_next_of_kin()
	  {
		  global $user_id;
		   		 
		  $this->form_validation->set_rules('first_name', 'First Name', 'required|alpha');
		  $this->form_validation->set_rules('other_names', 'Other Names', 'required');			
		  $this->form_validation->set_rules('phone_no','Phone Number', 'required|numeric');		  					
		  $this->form_validation->set_rules('relationship', 'Relationship', 'required|alpha');
		  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
		  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->next_of_kin();		  
		  }
		    else // passed validation proceed to post success logic
		  {
			 // build array for the model
			  $form_data = array(
							  'user_id' => $this->user_id,
							  'first_name' => $this->input->post('first_name'),							  
							  'other_names' => $this->input->post('other_names'),
							  'phone_no' => $this->input->post('phone_no'),
							  'relationship' => $this->input->post('relationship')							  
						  );
			  $table = 'next_of_kin';	
			  $this->main_model->insert_data($table, $form_data);
			  					 				  
			  redirect('user_management/next_of_kin');						  
		  }
	  }
	

}
?>