<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expenditure extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->login_model->authenticate();
		$this->load->library('form_validation');
		$this->load->model('expenditure_model');
		
		date_default_timezone_set("Africa/Nairobi");
	}
	
	public function add_project()
	{
		$user_id = $this->login_model->user_id();
	  	$corp_id = $this->login_model->corp_id();
		$data['members'] = $this->main_model->fetch_relevant_members($corp_id);
		$data['total_members'] = count($this->main_model->fetch_relevant_members($corp_id));
		$data['sess_data'] =  $this->session->flashdata('POST_DATA');
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datepicker/datepicker3.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$jquery_data['additional_jquery'] = array('plugins/datepicker/bootstrap-datepicker.js"');
		
		$jquery_data['functions'] = array(' <script type="text/javascript">												   
												   $.fn.datepicker.defaults.format = "M-dd-yyyy";
												  	$("#due_date").datepicker({
														autoclose: "true"
													  });
										 	 </script>
		   								');
					
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('expenditure/add_project',$data);
		$this->load->view('sections/footer',$jquery_data);
	}
	
	function insert_project_details()
	{
		$user_id = $this->login_model->user_id();
	  	$corp_id = $this->login_model->corp_id();
			
		$this->form_validation->set_rules('investment_name', 'Investment Name', 'required');	
		$this->form_validation->set_rules('total_amount', 'Total Amount', 'required|numeric');
		$this->form_validation->set_rules('amount_per_member', 'Amount Per Member', 'required|numeric');
		$this->form_validation->set_rules('due_date', 'Due Date', 'required');
		
		$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->add_project();		  
		  }
		  else // passed validation proceed to post success logic
		  {
			  // build array for the model
			  $id = $this->main_model->get_next_id('expenditure','id');
			  
			  //for expenditure table
			  $expenditure_data = array(
			  					'id' => $id,
								'investment_name' => $this->input->post('investment_name'),
								'total_amount' => $this->input->post('total_amount'),
								'amount_per_member' => ceil($this->input->post('amount_per_member')),
								'due_date' => strtotime($this->input->post('due_date')),
								'date_created' => time(),
								'authorisor' => $user_id
							  	);
			
								
			$this->main_model->insert_data('expenditure',$expenditure_data);					
			$members = $this->main_model->fetch_relevant_members($corp_id);
			foreach($members as $member)
			{
				
				//for investment_payments table
				$expenditure_data = array(
									'investment_id' => $id,
									'user_id' => $member['user_id'],
									'amount' => ceil($this->input->post('amount_per_member')),
									'status' => 0
									);
				$this->main_model->insert_data('investment_payments',$expenditure_data);
			
			}
			
			$data = array('JSFunction' => '
							<script type="text/javascript">	
							$(document).ready(function() {
								$("#displayMsg").html("Contribution details submitted successfully.");
							});
							</script>'					
							);
			//pass this data to notify the user that the record was saved successfully
			$this->session->set_flashdata('POST_DATA', $data);
			redirect('expenditure/add_project');
		  }
		
	}
	
	
	public function view_projects()
	{
		$user_id = $this->login_model->user_id();
		$corp_id = $this->login_model->corp_id();
					
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"',
		 									   'plugins/jAlert/src/jAlert-v3.css"'
												);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$projects_data['projects'] = $this->expenditure_model->get_all_projects($corp_id);
		foreach($projects_data as $val)
		{
			
			foreach($val as $data)
			{
				$investment[$data['id']] = $this->expenditure_model->get_payment_per_investment($data['id']);
			}
			
		}
		$projects_data['investment'] = $investment;
		$projectsCount = $this->expenditure_model->get_all_projects($corp_id);
	
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',
												  'plugins/datatables/dataTables.bootstrap.min.js"',
												  'plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"'
												  );
        //build data for the dataTables to be passed to view
		$arrayData = "";
		foreach($projectsCount as $count)
		{
			$arrayData .= ' <script type="text/javascript">
										$(function () {
										$("#dataTable'.$count['id'].'").DataTable();
													
							});
						</script>';
		}
												
		$jquery_data['functions'] = array($arrayData);						
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('expenditure/view_projects',$projects_data);
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//updates penalty as paid
	function check_investment()
	{
		$id = $this->input->post('id');
		$data = array('status' => 1, 'date_checked' => time(), 'authorisor'=>$this->login_model->user_id());	
			
		$response = $this->main_model->update_record('investment_payments','id',$id,$data); 
		
		if($response){return 1;}else{return 0;}
	}
	
	

}
?>