<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class General extends CI_Controller {

	function __construct()
	{
		parent:: __construct();
		$this->load->library('form_validation');
		$this->login_model->authenticate();
	}
	
	//call/redirect to this function when a user tries to access unauthorised page/url
	public function unauthorised()
	{
		
		$referer_url = $this->session->flashdata('referer_url' );
		$data = array('user_id'=>$this->login_model->user_id(), 'date_time'=>time(), 'ip_address'=>$this->input->ip_address(), 'url'=>$referer_url, 'type'=> 'unauthorised access');		
		$this->main_model-> insert_data('menu_access_logs', $data);
		
		$user_id = $this->login_model->user_id();
			
		$topbar_data['additional_css'] = array(NULL);
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('general/unauthorised');
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//reset user's password when logged out
	public function reset_password()
	{
		$user_id = $this->login_model->user_id();
			
		$topbar_data['additional_css'] = array(NULL);
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('general/reset_password');
		$this->load->view('sections/footer',$jquery_data);
	}
	
	
	//insert new password in the database.Update users table and inserts log data in password_reset table
	public function insert_new_password()
	{
		$user_id = $this->login_model->user_id();
			   
		$this->form_validation->set_rules('old_password', 'Old Password', 'required|callback_confirm_old_password');
		$this->form_validation->set_rules('new_password', 'New Password', 'required');			
		$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|matches[new_password]');
		
		$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
		
		if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		{		  
			$this->reset_password();		  
		}
		  else // passed validation proceed to post success logic
		{
		   // build array for the model
			$form_data = array(
							'user_id' => $user_id,
							'time_date' => time(),
							'ip_address' => $this->input->ip_address(),
							'old_password' =>  md5($this->input->post('old_password')),							  
							'new_password' =>  md5($this->input->post('new_password')),
							'type' =>  'user reset'						  
						);
			$data = array('password' => md5($this->input->post('new_password')));
			//update new password for the user in the users table
			$this->main_model->update_record('users','user_id',$user_id,$data);
			//insert a log about the change in password_reset
			$this->main_model->insert_data('password_reset', $form_data);
												
			redirect('user_management/user_profile/'.$user_id);						  
		}
	}
	
	//checks against the database to confirm the old password provided
	public function confirm_old_password($old_password)
	{
		$user_id = $this->login_model->user_id();		
		$subject_details = $this->main_model->get_one_row_in('users', 'user_id', $user_id);
		$old_pwd = $subject_details['password'];
		if ($old_pwd != md5($old_password))
		{
			$this->form_validation->set_message('confirm_old_password', 'The %s field MUST match the previously used password.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	
}


?>