<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payments_receipt extends CI_Controller
{
	  function __construct()
	   { 
		  parent::__construct();
		  $this->load->library('PdfPaymentReceipt');
		  $this->load->model('payments_model');
	   }
	   
	 
	  private function returnReceiptName($transaction_id)
	   {
		  $transaction_details = $this->payments_model->get_transaction_details($transaction_id);
		  return $transaction_details[0]->transaction_id.'_'.$transaction_details[0]->date_time.".pdf"; 
	   } 
	   
	  private function populateReceipt($transaction_id)
	   {
		  $transaction_details = $this->payments_model->get_transaction_details($transaction_id);
		  return $transaction_details[0]; 
	   }
	 
	  private function generateReceiptContent($pdf,$transaction)
	  {
		  // add a page
		  $pdf->AddPage('P','A6');
		  //set pageWidth
		  $pageWidth = $pdf->getPageWidth();
		  $pageMargrins = $pdf->getMargins();
		  $width = 77;
		  $x = $pdf->GetX();
		  $y = $pdf->GetY();
		  $subjectName = $this->main_model->get_first_name($transaction->user_id);
		  $authorisorName = $this->main_model->get_full_name($transaction->authorisor);
		  $amount = $this->convert_number_to_words($transaction->total);
		  $style = array('join' => 'miter', 'dash' => '2,1', 'color' => array(0, 0, 0));
		  $pdf->SetFont('helvetica', '', 8);
		  $pdf->SetTextColor(0, 0, 0);		  
		 
		  //MultiCell($w,$h,$txt,$border = 0,$align = 'J',$fill = false,$ln = 1,$x = '',$y = '',$reseth = true,$stretch = 0,$ishtml = false,$autopadding = true,$maxh = 0,$valign = 'T',$fitcell = false);		  
		  
		  $pdf->multiCell($width / 2, 0, 'Membesrship No. '.$transaction->user_id, '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY()-9); 
		  $pdf->multiCell($width / 2, 0, 'Name: '.$subjectName, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());		  
		  
		  $pdf->multiCell($width / 2, 0, 'Date: '.date("d - M - Y"), '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, 'Time: '.date("H:i:s"), '0', 'R', false, 1, $pdf->getX(), $pdf->getY());		  
		  $pdf->Line($x,$y,$x+80,$y,$style); 
		  $pdf->ln();
		  
		  
		  $pdf->multiCell($width / 2, 0, 'RECEIPT NO. '.$transaction->transaction_id, '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY()); 
		  $pdf->multiCell($width / 2, 0, '', '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  
		  $pdf->multiCell($width / 2, 0, '', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY()); 
		  $pdf->multiCell($width / 2, 0, 'Kshs', '0', 'R', false, 1, $pdf->getX(), $pdf->getY()); 
		  
		  $pdf->multiCell($width / 2, 0, 'Registration Fee', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());
		  $pdf->multiCell($width / 2, 0, $transaction->reg_fee, '0', 'R', false, 1, $pdf->getX(), $pdf->getY()); 
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Share Capital', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, $transaction->share_capital, '0', 'R', false, 1, $pdf->getX(), $pdf->getY()); 
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Service Charge', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());
		  $pdf->multiCell($width / 2, 0, $transaction->service_charge, '0', 'R', false, 1, $pdf->getX(), $pdf->getY()); 
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Loan Repayment', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, $transaction->loan_repay, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Loan Interest', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());
		  $pdf->multiCell($width / 2, 0, $transaction->interest, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln(); 
		  
		  $pdf->multiCell($width / 2, 0, 'Loan Penalty', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, $transaction->loan_penalty, '0', 'R', false, 1, $pdf->getX(), $pdf->getY()); 
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Default Penalty', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());
		  $pdf->multiCell($width / 2, 0, $transaction->default_penalty, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln(); 
		  
		  $pdf->multiCell($width / 2, 0, 'Withdrawal Fee', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, $transaction->withdrawal_fee, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Others:   ..........................', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, '0', '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Total amount received(Kshs)', '0', 'L', false, 0, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  $pdf->multiCell($width / 2, 0, $transaction->total, '0', 'R', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln();
		  
		  $pdf->multiCell($width / 2, 0, 'Amount in words : ', '0', 'L', false, 1, $pdf->getPageWidth()/2 - $width/2, 105);
		  $pdf->multiCell($width , 0, $amount, '0', 'L', false, 1, $pdf->getX(), $pdf->getY());
		  $pdf->ln();
		  
		  $pdf->Line($pdf->getX(),121,$pdf->getX()+80,121,$style);
		  $pdf->multiCell($width, 0, 'Receiving Officer: '. $authorisorName, '0', 'L', false, 1, $pdf->getPageWidth()/2 - $width/2, 122);
		  $pdf->ln(); 
		  $pdf->multiCell($width, 0, 'Receiving Officer\'s Signature .............................................', '0', 'L', false, 1, $pdf->getPageWidth()/2 - $width/2, $pdf->getY());	
		  
		  
		  return $pdf;
	  }

	  function return_receipt($transaction_id)
	  {
		  $serverRoot = base_url();		  
		  $receiptName = $this->returnReceiptName($transaction_id);
		  $name = "Kenneth Njoroge";	
		  // create new PDF document		 
		  $pdf = new PdfPaymentReceipt('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		  
		  // set document information
		  $pdf->SetCreator(PDF_CREATOR);
		  $pdf->SetAuthor('Thomas Njoroge');
		  $pdf->SetTitle('Receipt');
		  $pdf->SetSubject('Customer Receipt');
		  
		  // set header and footer fonts
		  $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		  $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		  
		  // set default monospaced font
		  $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		  
		  // set margins
		  $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		  //$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		  $pdf->SetHeaderMargin(5);
		  $pdf->SetFooterMargin(13);
		  
		  // set auto page breaks
		  $pdf->SetAutoPageBreak(TRUE, 0);
		  
		  // set image scale factor
		  //$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		  
		  // set some language-dependent strings (optional)
		  if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
			  require_once(dirname(__FILE__).'/lang/eng.php');
			  $pdf->setLanguageArray($l);
		  }
		  
		  $transaction_details = $this->populateReceipt($transaction_id);
		  $pdf = $this->generateReceiptContent($pdf,$transaction_details);
		  
		  //Close and output PDF document
		  //the server root requires editing to work on the hosted linux server- on top is online server copy
		  $pdf->Output($_SERVER['DOCUMENT_ROOT'] .'documents/receipts/'.$receiptName, 'F');
		  //$pdf->Output($_SERVER['DOCUMENT_ROOT'] .'saccomanager/documents/receipts/'.$receiptName, 'F');
		  return $receiptName;
	  }
	  
	  private function convert_number_to_words($number)
	  {   
		$hyphen      = '-';
		$conjunction = ' and ';
		$separator   = ', ';
		$negative    = 'negative ';
		$decimal     = ' point ';
		$dictionary  = array(
			0                   => 'zero',
			1                   => 'one',
			2                   => 'two',
			3                   => 'three',
			4                   => 'four',
			5                   => 'five',
			6                   => 'six',
			7                   => 'seven',
			8                   => 'eight',
			9                   => 'nine',
			10                  => 'ten',
			11                  => 'eleven',
			12                  => 'twelve',
			13                  => 'thirteen',
			14                  => 'fourteen',
			15                  => 'fifteen',
			16                  => 'sixteen',
			17                  => 'seventeen',
			18                  => 'eighteen',
			19                  => 'nineteen',
			20                  => 'twenty',
			30                  => 'thirty',
			40                  => 'fourty',
			50                  => 'fifty',
			60                  => 'sixty',
			70                  => 'seventy',
			80                  => 'eighty',
			90                  => 'ninety',
			100                 => 'hundred',
			1000                => 'thousand',
			1000000             => 'million',
			1000000000          => 'billion',
			1000000000000       => 'trillion',
			1000000000000000    => 'quadrillion',
			1000000000000000000 => 'quintillion'
		);
	   
		if (!is_numeric($number)) {
			return false;
		}
	   
		if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
			// overflow
			trigger_error(
				'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
				E_USER_WARNING
			);
			return false;
		}
	
		if ($number < 0) {
			return $negative . $this->convert_number_to_words(abs($number));
		}
	   
		$string = $fraction = null;
	   
		if (strpos($number, '.') !== false) {
			list($number, $fraction) = explode('.', $number);
		}
	   
		switch (true) {
			case $number < 21:
				$string = $dictionary[$number];
				break;
			case $number < 100:
				$tens   = ((int) ($number / 10)) * 10;
				$units  = $number % 10;
				$string = $dictionary[$tens];
				if ($units) {
					$string .= $hyphen . $dictionary[$units];
				}
				break;
			case $number < 1000:
				$hundreds  = $number / 100;
				$remainder = $number % 100;
				$string = $dictionary[$hundreds] . ' ' . $dictionary[100];
				if ($remainder) {
					$string .= $conjunction . $this->convert_number_to_words($remainder);
				}
				break;
			default:
				$baseUnit = pow(1000, floor(log($number, 1000)));
				$numBaseUnits = (int) ($number / $baseUnit);
				$remainder = $number % $baseUnit;
				$string = $this->convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
				if ($remainder) {
					$string .= $remainder < 100 ? $conjunction : $separator;
					$string .= $this->convert_number_to_words($remainder);
				}
				break;
		}
	   
		if (null !== $fraction && is_numeric($fraction)) {
			$string .= $decimal;
			$words = array();
			foreach (str_split((string) $fraction) as $number) {
				$words[] = $dictionary[$number];
			}
			$string .= implode(' ', $words);
		}
	   
		return $string;
	}
	
}
//============================================================+
// END OF FILE
//============================================================+


?>