<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Penalties extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->login_model->authenticate();
		$this->load->library('form_validation');
		$this->load->model('penalties_model');
		
		date_default_timezone_set("Africa/Nairobi");
	}
	
	
	public function add_penalty()
	{
		$user_id = $this->login_model->user_id();
	  	$corp_id = $this->login_model->corp_id();
		$data['members'] = $this->main_model->fetch_relevant_members($corp_id);
		$data['sess_data'] =  $this->session->flashdata('POST_DATA');
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/select2/select2.min.css"',
											   'plugins/datepicker/datepicker3.css"'
												);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$jquery_data['additional_jquery'] = array('plugins/select2/select2.full.min.js"',
												  'plugins/datepicker/bootstrap-datepicker.js"'
												  );
		
		$jquery_data['functions'] = array(' <script type="text/javascript">
												  $("#select2").select2({
												   placeholder: "Select a Member"
												   });
												   
												   $("#reason").select2({
												   placeholder: "Select a Reason"
												   });
												   
												   $.fn.datepicker.defaults.format = "M-dd-yyyy";
												  	$("#date_time").datepicker({
														autoclose: "true"
													  });
										 	 </script>
		   								');
					
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		//for server copy diversity is corp_id 2
		if($corp_id == 2)
		{
			$this->load->view('penalties/diversity/add_penalty',$data);
		}
		else
		{
			$this->load->view('payments/add_penalty',$data);
		}
		$this->load->view('sections/footer',$jquery_data);
	}
	
	
	function insert_diversity_penalty()
	{	
		$this->form_validation->set_rules('member_name', 'Member Name', 'required');	
		$this->form_validation->set_rules('date_time', 'Date', 'required');
		$this->form_validation->set_rules('reason', 'Reason', 'required');
		$this->form_validation->set_rules('amount', 'Amount', 'required|numeric');
		
		$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->add_penalty();		  
		  }
		  else // passed validation proceed to post success logic
		  {
			  // build array for the model	
			  $form_data = array(
								'user_id' => $this->input->post('subject_id'),
								'date_time' => strtotime($this->input->post('date_time')),
								'reason' => $this->input->post('reason'),
								'amount' => $this->input->post('amount'),
								'status' => 0,
								'time_recorded' => time(),
								'authorisor' => $this->login_model->user_id()
							  	);
			$this->main_model->insert_data('penalties',$form_data);
			$data = array('JSFunction' => '
							<script type="text/javascript">	
							$(document).ready(function() {
								$("#displayMsg").html("Penalty details submitted successfully.");
							});
							</script>'					
							);
			//pass this data to notify the user that the record was saved successfully
			$this->session->set_flashdata('POST_DATA', $data);
			redirect('penalties/add_penalty');
		  }
		
	}
	
	
	public function view_penalties()
	{
		$user_id = $this->login_model->user_id();
		$corp_id = $this->login_model->corp_id();
					
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"',
		 									   'plugins/jAlert/src/jAlert-v3.css"'
												);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$penalties_data['penalties'] = $this->penalties_model->get_all_penalties($corp_id);
		
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',
												  'plugins/datatables/dataTables.bootstrap.min.js"',
												  'plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"'
												  );
		$jquery_data['functions'] = array(
											' <script type="text/javascript">
													$(function () {
													$("#viewPenalties").DataTable();
													});
											</script>'							
  											);						
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('penalties/diversity/view_penalties',$penalties_data);
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//updates penalty as paid
	function check_penalty()
	{
		$id = $this->input->post('id');
		$data = array('status' => 1);	
			
		$response = $this->main_model->update_record('penalties','id',$id,$data); 
		 
		if($response){return 1;}else{return 0;}
	}
	
}
?>