<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Permissions extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->login_model->authenticate();
		$this->load->model('permissions_model');
	}
		
	public function menu_control()
	{
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
		$corp_id = $this->login_model->corp_id();
					
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/select2/select2.min.css"',
											   'plugins/jAlert/src/jAlert-v3.css"'
											);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		if($user_type == 1)
		{
			$data_corps['corporations'] = $this->main_model->get_all_data('corporations');
		}
		else
		{
			$data_users['users'] = $this->main_model-> get_relevant_data('users', 'corporation_id', $corp_id);
		}
		
		$jquery_data['additional_jquery'] = array('plugins/select2/select2.full.min.js"',
												  'plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"',
												  'dist/js/permissions/functions.js"'
												  );
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		if($user_type==1)
		{
			$this->load->view('permissions/menu_control_superAdmin',$data_corps);
		}
		else
		{
			$this->load->view('permissions/menu_control_Admin',$data_users);
		}
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//for testing
	function get_available_modules()
	{
		$modules = $this->permissions_model->get_granted_submenu_perCorporation_perModule(2,2);
		
		print_r($modules);
	}
	
	function return_permissions_granted_per_corporation_or_user()
	{
		$id= $this->input->post('id');
		$type= $this->input->post('type');
		$granted_permissions = $this->permissions_model->get_permissions_granted_per_corporation_or_user($id,$type);
		
		print_r($granted_permissions);
	}
	 
	
	function return_all_available_modules()
	{
		$id=  $this->input->post('id');
		$type=  $this->input->post('type');
		$available_modules = $this->permissions_model->get_all_available_modules($id,$type);
		
		print_r($available_modules);
	}
	
	//this function is called by Ajax. It returns all submenu for that module
	function return_submenu_for_module()
	{		
		$module_id=  $this->input->post('module_id');
		$type=  $this->input->post('type');
		
		if($type == 'corporation' || 'corporations_default')
		{
			$all_submenu = $this->permissions_model->get_sub_menu($module_id);
		}
		else if($type == 'user')
		{
			$all_submenu = $this->permissions_model->get_sub_menu_forCorporation($module_id);
		}
		$submenu = implode("," , $all_submenu);
		
		//this function no longer updates the db,It just checks/unchecks the appropriate checkboxes
		//$this->permissions_model->update_submenu_permission($corporation_id,$module_id,$submenu);
		
		echo json_encode($all_submenu);	
	}
	
	public function insert_corporation_orUser_modules()
	{		 
		$id = $this->input->post('id');
		$menu_id = $this->input->post('menu_id');
		$type = $this->input->post('type');
		
		if($type == 'corporation')
		{		
			$form_data = array(
							'corporation_id' => $id,
							'menu' => $menu_id,							  
							'sub_menu' => $this->input->post('')							  
						);
			$table = 'corporation_modules';
		}
		else if($type == 'user')
		{		
			$form_data = array(
							'user_id' => $id,
							'menu' => $menu_id,							  
							'sub_menu' => $this->input->post('')							  
						);
			$table = 'menu_control';
		}
		
		$this->main_model->insert_data($table, $form_data);																		
	   
	}
	
	public function insert_corporation_sub_menu()
	{		 
		$corporation_id = $this->input->post('corporation_id');
		$menu_id = $this->input->post('menu_id');
				
		$form_data = array(
						'corporation_id' => $corporation_id,
						'menu' => $menu_id,							  
						'sub_menu' => $this->input->post('')							  
					);
		$table = 'corporation_modules';	
		$this->main_model->insert_data($table, $form_data);
	}
	
	//this function is called via Ajax to update submenu from granted module
	function update_submenu_permission_forAjax()
	{		 
		$id = $this->input->post('id');
		$module_id = $this->input->post('module_id');
		$submenu = $this->input->post('submenu');
		$type = $this->input->post('type');
						
		$this->permissions_model->update_submenu_permission($id,$module_id,$submenu,$type);
		
	}
	
	//this function is called by ajax to remove module permission
	public function delete_module_permission()
	{		 
		$id = $this->input->post('id');
		$type = $this->input->post('type');
		
		$form_data = array('id' => $id,'type' => $type);
		
		if($type == 'corporation')
		{
			$table = 'corporation_modules';
		}
		else if($type == 'user')
		{
			$table = 'menu_control';
		}
		else if($type == 'corporations_default')
		{
			$table = 'corporations_default_permissions';
		}
		else if($type == 'corporation_staff' || $type == 'corporation_member')
		{
			$table = 'default_permissions';
		}
		
		$this->permissions_model->remove_module_access($table, $id);																		
	   
	}
	
	
	
	/*Activate And Deactivate Account
	 Super Admin can deactivate a corporation(i.e all accounts)
	 Admin can activate/deactivate individual Accounts in the corporation*/
	
	public function account_activation()
	{
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
		$corp_id = $this->login_model->corp_id();
					
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"',
		 									   'plugins/jAlert/src/jAlert-v3.css"'
												);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		if($user_type == 1)
		{
			$data_corps['corporations'] = $this->main_model->get_all_data('corporations');
			$data_corps['corp_accounts'] = $this->permissions_model->corporation_accounts_status();
		}
		else
		{
			$data_users['members'] = $this->main_model-> get_relevant_data('users', 'corporation_id', $corp_id);
		}
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',
												  'plugins/datatables/dataTables.bootstrap.min.js"',
												  'plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"',
												  'dist/js/permissions/functions.js"'
												  );
		$jquery_data['functions'] = array(
											' <script type="text/javascript">
											
													$(function () {
													$("#corporationAccounts").DataTable();
													});
													
													$(function () {
													$("#members").DataTable();
													});
											</script>'							
  											);						
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		if($user_type==1)
		{
			$this->load->view('permissions/account_activation_superAdmin',$data_corps);
		}
		else
		{
			$this->load->view('permissions/account_activation_Admin',$data_users);
		}
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//this function is called by Ajax to activate account(s)
	function activate_account()
	{
		$id = $this->input->post('id');
		$type = $this->input->post('type');
				
		$response = $this->permissions_model->activate_user_account($type, $id); 
		
		if($response){return 1;}else{return 0;}
	}
	
	//this function is called by Ajax to deactivate account(s)
	function deactivate_account()
	{
		$id = $this->input->post('id');
		$type = $this->input->post('type');
				
		$response = $this->permissions_model->deactivate_user_account($type, $id); 
		
		if($response){return 1;}else{return 0;}
	}
	
	
	
	/*DEFAULT PERMISSIONS
	
	For corporations; those are the basic minimum modules any corporation will be assigned automatically on creation
	For user types; these will be set per corporation by the admin. An user created will automatically have the basic
	minimum module permissions on creation. 
	Any Admin created will get the corresponding corporation's basic minimum permissions*/
	
	function default_permissions()
	{
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
		$corp_id = $this->login_model->corp_id();
					
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/select2/select2.min.css"',
											   'plugins/jAlert/src/jAlert-v3.css"'
											);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		if($user_type == 1)
		{
			//$data_modules['all_modules'] = $this->permissions_model->get_all_available_modules_forCorporations();
			$data_modules['permissions_granted'] = $this->permissions_model->get_permissions_granted_per_corporation_or_user(NULL,'corporations_default');
			$data_modules['available_modules'] = $this->permissions_model->get_all_available_modules(NULL,'corporations_default');
		}
		
		$jquery_data['additional_jquery'] = array('plugins/select2/select2.full.min.js"',
												  'plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"',
												  'dist/js/permissions/functions.js"'
												  );
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		if($user_type==1)
		{
			$this->load->view('permissions/default_permissions_superAdmin',$data_modules);
		}
		else
		{
			$this->load->view('permissions/default_permissions_Admin');
		}
		$this->load->view('sections/footer',$jquery_data);
	}
	
	
	//inserts the default permissions into database
	function insert_default_permissions()
	{
		$menu_id = $this->input->post('menu_id');
		$type = $this->input->post('type');
		
		//for user_types
		$corp_id = $this->login_model->corp_id();
		if($type == 'corporation_staff'){$user_type = 3; } else if($type == 'corporation_member'){$user_type = 4; }
				
		
		if($type == 'corporations_default')
		{
			$table = 'corporations_default_permissions';
			$form_data = array('menu' => $menu_id,'sub_menu' => '');
		}
		else
		{
			$table = 'default_permissions';
			$form_data = array('corporation_id' => $corp_id,'user_type' => $user_type,'menu' => $menu_id,'sub_menu' => '');
		}
		
		$this->main_model->insert_data($table, $form_data);	
	}
}
?>