<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		$this->login_model->authenticate();
		$this->load->model('reports_model');
		
		date_default_timezone_set("Africa/Nairobi");
	}
	
	//loads a dataTable with a corporation's summary of payments
	public function financial_report()
	{
		$user_id = $this->login_model->user_id();
		$corp_id = $this->login_model->corp_id();
		$data['payments'] = $this->reports_model-> fetch_corporation_finacial_report($corp_id);
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',			
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array('<script type="text/javascript">
											  $(function () {
												$("#financial_report").DataTable();
											  });
											</script>'					
										);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('reports/financial_report',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
	//loads a dataTable with a corporation's summary of payments- EXPORTABLE DATA TABLE
	/*DataTable css: 'plugins/datatables/dataTables.bootstrap.css"','plugins/datatables/exportable/data-table.css"'*/
	public function contributions_per_member()
	{
		$user_id = $this->login_model->user_id();
		$corp_id = $this->login_model->corp_id();
		$data['corp_members'] = $this->reports_model-> get_corporation_members($corp_id);
		$data['contributions'] = $this->reports_model-> fetch_contributions_per_member($corp_id);
		$data['total'] = $this->reports_model-> fetch_total_per_member($corp_id);
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/exportable/css/buttons.dataTables-1.1.2.min.css"',
											   'plugins/datatables/exportable/css/jquery.dataTables-1.10.11.min.css"',
											   'plugins/datatables/responsive/responsive.dataTables.min.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/exportable/js/jquery.dataTables-1.10.11.min.js"',
												  'plugins/datatables/exportable/js/dataTables.buttons-1.1.2.min.js"',
												  'plugins/datatables/exportable/js/buttons.flash.min-1.1.2.js"',
												  'plugins/datatables/exportable/js/jszip.min-2.5.0.js"',
												  'plugins/datatables/exportable/js/pdfmake-0.1.18.min.js"',
												  'plugins/datatables/exportable/js/vfs_fonts-0.1.18.js"',
												  'plugins/datatables/exportable/js/buttons.html5-1.1.2.min.js"',
												  'plugins/datatables/exportable/js/buttons.print-1.1.2.min.js"',
												  'plugins/datatables/exportable/js/buttons.colVis-1.1.2.min.js"',
											   	  'plugins/datatables/responsive/dataTables.responsive.min.js"'		
												);
		
		$jquery_data['functions'] = array('<script type="text/javascript">
											$("#financial_report").DataTable({
												   "bSort" : false,
												   responsive: true,
												   "sDom": \'lf<"DTButtons"B<"clear">>rtip\',
													/*"sDom": \'<"top"fl<"clear">>,<"DTButtons"CB<"clear">>,<"table_content"t>r<"bottom"ip>\',*/
													buttons: [ \'copy\', \'csv\', \'excel\', \'pdf\', \'print\',\'colvis\']
												});
										   </script>'				
										);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('reports/contributions_per_member',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
}
?>