<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_management extends CI_Controller {
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->library('form_validation');
		$this->login_model->authenticate();
		$this->load->model('user_management_model');
		
			
	}
	
	public function test_menu_control($user_id)
	{
		//$parent_ids = $this->menu_control->get_relevant_parent_id($user_id);
		$menu = $this->menu_control->get_menu($user_id,1);
		print_r($menu);
	}
	 
	 
	public function member_registration()
	{
		$user_id = $this->login_model->user_id();
			
		$topbar_data['additional_css'] = array(NULL);
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/member_registration');
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//this function requires validation to ensure no allowed access bu changing url value
	public function next_of_kin($subject_id)
	{
		$subject_id = $subject_id;
		$user_id = $this->login_model->user_id();
		
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$data['kin'] = $this->main_model->get_relevant_data('next_of_kin','user_id',$subject_id);
		$data['subject_id'] = $subject_id;
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array(' <script type="text/javascript">
												$(function () {
												  $("#next_of_kin").DataTable();
												});
											  </script>'					
    									  );
						
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/next_of_kin',$data);
		$this->load->view('sections/footer',$jquery_data);
	}
	
	public function add_corporation()
	{
		$user_id = $this->login_model->user_id();
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$data['corporations'] = $this->main_model->get_ordered_rows('corporations','corporation_id');
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array(' <script type="text/javascript">
												$(function () {
												  $("#add_corporation").DataTable();
												});
											  </script>'					
    									  );
						
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/add_corporation',$data);
		$this->load->view('sections/footer',$jquery_data);
	}
	
	public function add_admin()
	{
		$user_id = $this->login_model->user_id();
		
		$data['corporations'] = $this->main_model->get_all_data('corporations');
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/select2/select2.min.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		$jquery_data['additional_jquery'] = array('plugins/select2/select2.full.min.js"');
		$jquery_data['functions'] = array('
			<script type="text/javascript">													
						  $("#corporation").on("change", function() {
						  $("#corporation2").val( $(this).find("option:selected").text() );													
						});													  
																		  
					   $("#corporation").select2({
						   placeholder: "Select Corporation"
						   });
		   </script>'					
		);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/add_admin',$data);
		$this->load->view('sections/footer',$jquery_data);
	}	
	
	public function add_staff()
	{
		$user_id = $this->login_model->user_id();
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array(NULL);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/add_staff');
		$this->load->view('sections/footer',$jquery_data);
	}
	
	private function upload_profile_pic()
	{
		$config['upload_path'] = 'images/profile_photos';
		$config['allowed_types'] = 'jpg|png|jpeg';
		$config['file_name'] = $_POST['national_id_no'].'_'.time();
		
		$this->load->library('upload',$config);
		
		if(!$this->upload->do_upload())
			{
				$error = array('error' =>$this->upload->display_errors());
				//$this->load->view('user_management/user_profile_view',$error);
				return 'default_image.jpg';
			}
			else
			{
				$datas = array('upload_data' => $this->upload->data());
				//print_r($datas);
				foreach($datas as $key => $val)
				{
					return $val['file_name'];
				}	
			}
	} 
	
	private function upload_corp_logo()
	{
		$config['upload_path'] = 'images/corp_logos';
		$config['allowed_types'] = 'jpg|png|jpeg';
		$config['file_name'] = trim($_POST['short_name']).'_logo';
		
		$this->load->library('upload',$config);
		
		if(!$this->upload->do_upload())
			{
				$error = array('error' =>$this->upload->display_errors());
				return 'default_logo.jpg';
			}
			else
			{
				$datas = array('upload_data' => $this->upload->data());
				foreach($datas as $key => $val)
				{
					return $val['file_name'];
				}	
			}
	}
	
	//loads a dataTable with member's details; requires validation to load relevant users only
	public function view_members()
	{
		$user_id = $this->login_model->user_id();
		$corp_id = $this->login_model->corp_id();
		$data['members'] = $this->user_management_model->get_users($corp_id,4);
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',			
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array('<script type="text/javascript">
											  $(function () {
												$("#members").DataTable();
											  });
											</script>'					
										);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/view_members',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
	//loads a dataTable with administrator's details-acceses by super admin only
	public function view_administrators()
	{
		$user_id = $this->login_model->user_id();
		$data['administrators'] = $this->user_management_model->get_admins();
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',			
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array('<script type="text/javascript">
											  $(function () {
												$("#administrators").DataTable();
											  });
											</script>'					
										);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/view_administrators',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
	//loads a dataTable with administrator's details-acceses by super admin only
	public function view_corporations()
	{
		$user_id = $this->login_model->user_id();
		$data['corporations'] = $this->main_model->get_all_data('corporations');
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array('plugins/datatables/dataTables.bootstrap.css"');
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);				
		
		$jquery_data['additional_jquery'] = array('plugins/datatables/jquery.dataTables.min.js"',			
												'plugins/datatables/dataTables.bootstrap.min.js"');
		
		$jquery_data['functions'] = array('<script type="text/javascript">
											  $(function () {
												$("#corporations").DataTable();
											  });
											</script>'					
										);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/view_corporations',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
		
	//function to load a user's profile; requires validation to restrict unauthorised access
	public function user_profile($subject_id)
	{
		$corporation_id = $this->login_model->corp_id();
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
		
		//validate that a member can only view his/her profile only
		if($user_type == 4)
		{
			if ($subject_id != $user_id)
			{
				$this->session->set_flashdata('referer_url', $_SERVER['REQUEST_URI']);
				redirect('general/unauthorised');
			}
		}
		//validate that admin/staff can view profile of members in the same corporation only
		else if($user_type == 3 || $user_type == 2)
		{
			$subject_details = $this->main_model->get_one_row_in('users', 'user_id', $subject_id);
			$users_corp_id = $subject_details['corporation_id'];
			
			if ($users_corp_id != $corporation_id)
			{
				$this->session->set_flashdata('referer_url', $_SERVER['REQUEST_URI']);
				redirect('general/unauthorised');
			}
		}
		$topbar_data['additional_css'] = array('plugins/jAlert/src/jAlert-v3.css"');
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array('plugins/jAlert/src/jAlert-v3.js"',
												  'plugins/jAlert/src/jAlert-functions.js"');
		$jquery_data['functions'] = array(
		'<script type="text/javascript">
		
				 function deactivateAccountForJAlert(type,id)
				{
					  var type = type;
					  var id = id;					  					  
					  var form_data = {\'type\': type,\'id\': id};					  
					  console.log(form_data);
					  $.ajax({ 
						  type 		: \'POST\',
						  url 		: url+\'permissions/deactivate_account\', 
						  data 		: form_data, 
						  success 	: function(data) 
									  {	
										 console.log("here");	
										 console.log(data);							
									  }
					  });	
				}
				
				function deactivateAccount(type,id)
				  {
						var type = type;
					  	var id = id;
					  	//event.preventDefault();//throws error on mozilla: ReferenceError: event is not defined
						$.jAlert({
							\'title\': \'Deactivate User Account\',
							\'content\': \'Are you sure you want to deactivate the user account?\',
							\'theme\': \'blue\',
							\'size\': \'sm\',
							\'showAnimation\': \'fadeInUp\',
							\'hideAnimation\': \'fadeOutDown\',
							\'btns\': {
										\'text\': \'Deactivate Account\',
										\'theme\': \'green\',
										\'onClick\': function(e,btn){e.preventDefault();deactivateAccountForJAlert(type,id);}
									  }
							 
					   });					  
				  }
		</script>');
		
		$data['row'] = $this->user_management_model->fetch_user_data($subject_id);;
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		
		if($corporation_id == 2)
		{
			$this->load->view('user_management/diversity/user_profile_view',$data);
		}
		else
		{
			$this->load->view('user_management/user_profile_view',$data);
		}
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
	//function used to edit users profile
	function edit_profile($subject_id)
	{		
		$corporation_id = $this->login_model->corp_id();
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
		
		//validate that a member can only edit his/her profile only
		if($user_type == 4)
		{
			if ($subject_id != $user_id)
			{
				$this->session->set_flashdata('referer_url', $_SERVER['REQUEST_URI']);
				redirect('general/unauthorised');
			}
		}
		//validate that admin/staff can view profile of members in the same corporation only
		else if($user_type == 3 || $user_type == 2)
		{
			$subject_details = $this->main_model->get_one_row_in('users', 'user_id', $subject_id);
			$users_corp_id = $subject_details['corporation_id'];
			
			if ($users_corp_id != $corporation_id)
			{
				$this->session->set_flashdata('referer_url', $_SERVER['REQUEST_URI']);
				redirect('general/unauthorised');
			}
		}
		$topbar_data['additional_css'] = array(NULL);
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
												  
		$data['row'] = $this->user_management_model->fetch_user_data($subject_id);;
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		
		if($corporation_id == 2)
		{
			$this->load->view('user_management/diversity/edit_profile',$data);
		}
		else
		{
			$this->load->view('user_management/user_profile_view',$data);
		}
		$this->load->view('sections/footer',$jquery_data);
	}
	
	//updates the profiles info in users table and logs table: profile_changes
	function update_user_profile($subject_id)
	{
		$user_id = $this->login_model->user_id();		  
		
		$this->form_validation->set_rules('first_name', 'First Name', 'required|alpha');
		$this->form_validation->set_rules('other_names', 'Other Names', 'required');			
		$this->form_validation->set_rules('phone_no','Phone Number', 'required|callback_is_valid_phone_no');					
		$this->form_validation->set_rules('email_address', 'Email Address', 'valid_email');
			
		$this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	
		if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		{		  
			$this->edit_profile($subject_id);		  
		}
		else // passed validation proceed to post success logic
		{
		   	// build array for the model			 
		  	$uploaded_file_name =$this->upload_profile_pic();
			if($uploaded_file_name == 'default_image.jpg')
			{
				$file_name = $this->input->post('userfile');
			}
			else
			{
				$file_name = $uploaded_file_name;
			}
			  
			$profile_changes_data = array(
							'user_id' => $subject_id,
							'photo' => $file_name,
							'first_name' => $this->input->post('first_name'),
							'other_names' => $this->input->post('other_names'),
							'email_address' => $this->input->post('email_address'),
							'phone_no' => $this->input->post('phone_no'),
							'date_time' => time(),
							'ip_address' => $this->input->ip_address(),
							'authorisor' => $user_id							  
						);
			$user_tbl_data = array(
							'photo' => $file_name,
							'first_name' => $this->input->post('first_name'),
							'other_names' => $this->input->post('other_names'),
							'email_address' => $this->input->post('email_address'),
							'phone_no' => $this->input->post('phone_no'),
							'name' =>$this->input->post('first_name')." ".$this->input->post('other_names'), 
								);
			
			$this->main_model->insert_data('profile_changes', $profile_changes_data);
			$this->main_model->update_record('users','user_id', $subject_id, $user_tbl_data);			 				  
			redirect('user_management/user_profile/'.($subject_id));						  
		}				
	}
	
	//validate phone number used while updating users profile
	public function is_valid_phone_no($phone_no)
	{
		$prefix = substr($phone_no,0,4);
		$length = strlen($phone_no);
		
		if ($prefix != '+254')
		{
			$this->form_validation->set_message('is_valid_phone_no', 'The %s field MUST start with +254.');
			return FALSE;
		}
		else if($length != 13)
		{
			$this->form_validation->set_message('is_valid_phone_no', 'The %s field MUST have exactly 13 characters.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	//function to load a staff's profile-admins & staff; requires validation to restrict unauthorised access
	public function staff_profile($subject_id)
	{
		$user_id = $this->login_model->user_id();
		
		$topbar_data['profile_photo'] = $this->main_model->create_thumbnail(160,160,$user_id);
		$topbar_data['additional_css'] = array(NULL);
		$sidebar_data['menu'] = $this->menu_control->get_menu($user_id);
		
		$jquery_data['additional_jquery'] = array(NULL);
		$jquery_data['functions'] = array(NULL);
		
		$data['row'] = $this->user_management_model->fetch_user_data($subject_id);
		$data['profile_photo'] = $this->main_model->create_thumbnail(300,250,$subject_id);
		
		$this->load->view('sections/topbar',$topbar_data);
		$this->load->view('sections/sidebar',$sidebar_data);
		$this->load->view('user_management/staff_profile_view',$data);
		$this->load->view('sections/footer',$jquery_data);
	
	}
	
	//this function adds/inserts the details of a member into the database	
	 public function insert_member_details()
	  {	  
	      $corporation_id = $this->login_model->corp_id();
		  $user_id = $this->login_model->user_id();
		  $user_type = 4;
		  $status = 1;
		  $next_id = $this->main_model->get_next_id('users','user_id');			  
		  
		  $this->form_validation->set_rules('member_no', 'Member Number', 'required|is_numeric');
		  $this->form_validation->set_rules('email_address', 'Email Address', 'valid_email');
		  $this->form_validation->set_rules('first_name', 'First Name', 'required|alpha');			
		  $this->form_validation->set_rules('phone_no','Phone Number', 'required|numeric|exact_length[9]');						
		  $this->form_validation->set_rules('other_names', 'Other Names', 'required');					
		  $this->form_validation->set_rules('national_id_no', 'National ID NO', 'required|is_numeric');
		  $this->password = md5(strtolower($this->input->post('first_name')));
			  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->member_registration();		  
		  }
		  else // passed validation proceed to post success logic
		  {
			 // build array for the model			 
			$file_name =$this->upload_profile_pic();
				
			  $form_data = array(
							  'user_id' => $next_id,
							  'member_no' => $this->input->post('member_no'),
							  'email_address' => $this->input->post('email_address'),
							  'first_name' => $this->input->post('first_name'),
							  'phone_no' => "+254". $this->input->post('phone_no'),
							  'other_names' => $this->input->post('other_names'),
							  'name' =>$this->input->post('first_name')." ".$this->input->post('other_names'),
							  'national_id_no' => $this->input->post('national_id_no'),
							  'corporation_id' => $corporation_id,
							  'user_type' => $user_type,
							  'date_created' => time(),
							  'password' => $this->password,
							  'photo' => $file_name,
							  'created_by' => $user_id,
							  'active_status'=>$status							  
						  );
			  $table = 'users';	
			  $this->main_model->lock_table('users');
			  $this->main_model->insert_data($table, $form_data);
			  $this->main_model->unlock_table('users');
			  $this->insert_default_permissions($next_id,$corporation_id,'member');
			  
			  //$insert_id = $this->db->insert_id();					 				  
			  redirect('user_management/user_profile/'.($next_id));						  
		  }		
	  }
	  
	  //this function adds/inserts the details of a user-admin or staff
	 public function insert_user($user_type)
	  {
		  $user_type = $user_type;
		  if($user_type == 2)
			{
				$corporation_id = $this->input->post('corporation');			  
			}
		  else if($user_type == 3) 
		  	{	  
	      		$corporation_id = $this->login_model->corp_id();
			}
		  $user_id = $this->login_model->user_id();		  
		  $status = 1;
		  
		  //Validation rules set in config/form_validation
		
		  $this->password = md5(strtolower($this->input->post('first_name')));
		  $next_id = $this->main_model->get_next_id('users','user_id');	  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
	  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {
			  if($user_type ==2)
			  {
				  $this->add_admin();
			  }else
			  	  $this->add_staff();
		  }
		  else // passed validation proceed to post success logic
		  {
			 // build array for the model			 
			$file_name =$this->upload_profile_pic();
				
			  $form_data = array(
							  'user_id' => $next_id,
							  'email_address' => $this->input->post('email_address'),
							  'first_name' => $this->input->post('first_name'),
							  'phone_no' => "+254". $this->input->post('phone_no'),
							  'other_names' => $this->input->post('other_names'),
							  'name' =>$this->input->post('first_name')." ".$this->input->post('other_names'),
							  'national_id_no' => $this->input->post('national_id_no'),
							  'corporation_id' => $corporation_id,
							  'user_type' => $user_type,
							  'date_created' => time(),
							  'password' => $this->password,
							  'photo' => $file_name,
							  'created_by' => $user_id,
							  'active_status'=>$status							  
						  );
			  $table = 'users';	
			  $this->main_model->lock_table('users');
			  $this->main_model->insert_data($table, $form_data);
			  $this->main_model->unlock_table('users');
			  if($user_type == 2)
				{
					$this->insert_default_permissions($next_id,$corporation_id,'admin');			  
				}
			  else if($user_type == 3) 
				{	  
					$this->insert_default_permissions($next_id,$corporation_id,'staff');
				}
			  
			  //$insert_id = $this->db->insert_id();//replaced by get_next_id()					 				  
			  redirect('user_management/staff_profile/'.($next_id));						  
		  }		
	  }
	  
	  public function insert_next_of_kin()
	  {
		  $subject_id = $this->input->post('subject_id', TRUE);
		  $user_id = $this->login_model->user_id();
		   		 
		  $this->form_validation->set_rules('first_name', 'First Name', 'required|alpha');
		  $this->form_validation->set_rules('other_names', 'Other Names', 'required');			
		  $this->form_validation->set_rules('phone_no','Phone Number', 'required|numeric|exact_length[9]');		  					
		  $this->form_validation->set_rules('relationship', 'Relationship', 'required|alpha');
		  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
		  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->next_of_kin($subject_id);		  
		  }
		    else // passed validation proceed to post success logic
		  {
			 // build array for the model
			  $form_data = array(
							  'user_id' => $subject_id,
							  'first_name' => $this->input->post('first_name'),							  
							  'other_names' => $this->input->post('other_names'),
							  'phone_no' => "+254". $this->input->post('phone_no'),
							  'relationship' => $this->input->post('relationship'),
							  'added_by' => $user_id							  
						  );
			  $table = 'next_of_kin';	
			  $this->main_model->insert_data($table, $form_data);
			  					 				  
			  redirect('user_management/next_of_kin/'.$subject_id);						  
		  }
	  }
	  
	public function insert_corporation()
	  {		   		 
		  $this->form_validation->set_rules('corporation_name', 'Corporation Name', 'required');
		  $this->form_validation->set_rules('short_name', 'Short Name', 'required');			
		  $this->form_validation->set_rules('phone_no','Phone Number', 'required|numeric|exact_length[9]');		  					
		  $this->form_validation->set_rules('address', 'Address', 'required');
		  
		  $this->form_validation->set_error_delimiters('<span class="error">', '</span>');
		  
		  if ($this->form_validation->run() == FALSE) // validation hasn't been passed
		  {		  
			  $this->add_corporation();		  
		  }
		    else // passed validation proceed to post success logic
		  {
			 // build array for the model
			  $corp_logo =$this->upload_corp_logo();
			  $nextId = $this->main_model->get_next_id('corporations','corporation_id');
			  $form_data = array(
							  'corporation_id' => $nextId,
							  'corporation_name' => $this->input->post('corporation_name'),							  
							  'short_name' => $this->input->post('short_name'),
							  'phone_no' => "+254". $this->input->post('phone_no'),
							  'address' => $this->input->post('address'),
							  'date_created' =>time(),
							  'logo' => $corp_logo							  
						  );
			  $table = 'corporations';	
			  $this->main_model->insert_data($table, $form_data);
			  $this->insert_default_permissions($nextId,null,'corporation');
			  					 				  
			  redirect('user_management/add_corporation');						  
		  }
	  }
	  
	  //function used to insert default permissions when an account is created i.e corporation, admin, staff, member
	  function insert_default_permissions($id, $corp_id, $type)
	  {
		  $this->main_model->default_permissions($id, $corp_id, $type);
	  }

}
?>