<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main_model extends CI_Model {

	function __construct()
    {
     parent::__construct();		
	
    }
	
	function insert_data($table, $form_data)
	{
		$this->db->insert($table, $form_data);
		if($this->db->affected_rows() == 1){return true;}else {return false;}	 
	}
	
	function return_insert_id($table, $form_data)
	{
		$this->db->insert($table, $form_data);
		if($this->db->affected_rows() == 1){return $this->db->insert_id();}else {return false;}	 
	}
	
	function get_all_data($table)
	{
		$query = $this->db->get($table);
		if($query->num_rows()>0){return $query->result();}else{return NULL;}
	}	
	
	function get_one_row_in($table, $pkname, $pkvalue){
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($pkname,$pkvalue);
		$query = $this->db->get();
		if ($query->num_rows() == 1){$row = $query->row_array(); return $row;  }
		else return NULL;
		}
		
	function update_record($table,$field,$field_value,$data)
	{
		$this->db->where($field, $field_value);
		$this->db->update($table, $data);
	}
	//$query = SELECT * FROM $table ORDER BY $field ASC
	function get_ordered_rows($table,$field)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->order_by($field,'ASC');
		
		$query = $this->db->get();
		if($query->num_rows()>0)
		{
			$row = $query->result();
			return $row;	
		}
		else
			return NULL;			
	}
	//this function returns the next id for the given field in the given table
	function get_next_id($table,$field)
	{
		//$query = "SELECT $field FROM $table ORDER BY $field DESC LIMIT 1";
		$this->db->select($field);
		$this->db->from($table);
		$this->db->order_by($field,'DESC');
		$this->db->limit(1);
		
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$row = $query->result_array();
			$last_id = $row[0][$field];
			$last_id = intval($last_id);
			$last_id +=1;
			return $last_id;	
		}
		else
			return 1;
	}
	
	//lock table to prevent another instance from writing
	function lock_table($table)
	{
		//$query = "LOCK TABLES $table WRITE";
		$query = "LOCK TABLES $table";
		mysql_query($query);
	}
	
	//unlock the table to allow other instances access it
	function unlock_table($table)
	{
		$query = "UNLOCK TABLES $table";
		mysql_query($query);
	}
	//gets data from a table for a specific foreign key
	function get_relevant_data($table, $field, $value){
	$this->db->select('*');
	$this->db->from($table);
	$this->db->where($field,$value);
	
	$query = $this->db->get();
	if ($query->num_rows() > 0)
	{
		$row = $query->result(); 
		return $row;  
	}
	else 
		return NULL;
	}
	
	//returns the profile pic name of the user_id passed
	function get_profile_pic($user_id)
	{
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where('user_id',$user_id);
		$query = $this->db->get();
		
		$photo_array = $query->result_array();
		$photo = $photo_array[0]['photo'];
		return $photo;
	}
	
	
	//for testing create_thumbnail
	function giveMePhoto($user_id)
	{		
		//$data['photo'] = $this->user_management_model->get_profile_pic($user_id);
		$user_id = $user_id;
		$data['photo'] = $this->create_thumbnail($width=300, $height=250, $user_id);
		$this->load->view('sections/topbar',$data);
	}
	
	//generates a thumnail of pic using the provided dimensions in func arguments
	public function create_thumbnail($width, $height, $user_id)
    {
		$pic = $this->get_profile_pic($user_id);
        // Checking if the file exists, otherwise we use a default image
        $img = is_file('./images/profile_photos/'.$pic) ? $pic : 'default_image.jpg';
		
		if($img == 'default_image.jpg' )
		{
			return $img;
		}
		else
		{	 
			// If the thumbnail already exists, we just read it
			// No need to use the GD library again
			if( !is_file('./images/profile_photos/thumbs/'.$width.'x'.$height.'_'.$img) )
			{
				$config['image_library'] = 'gd2';			
				$config['source_image'] = './images/profile_photos/'.$img;
				$config['new_image'] = './images/profile_photos/thumbs/'.$width.'x'.$height.'_'.$img;
				//$config['create_thumb'] = TRUE;
				$config['maintain_ratio'] = TRUE;
				$config['width'] = $width;
				$config['height'] = $height;
				
				$this->load->library('image_lib'); 
				$this->image_lib->initialize($config);
			   
				if ( ! $thumb_nail = $this->image_lib->resize())
				{
					//echo $this->image_lib->display_errors();
					$thumb_nail = 'default_image.jpg';
					return $thumb_nail;
				}
				else
				{
					$thumb_nail = $width.'x'.$height.'_'.$img;
					return $thumb_nail;	
				}
				
				
			}
			else 
			{  
				//$thumb_nail = file('/images/profile_photos/thumbs/'.$width.'x'.$height.'_'.$img);
				$thumb_nail = $width.'x'.$height.'_'.$img;
				return $thumb_nail;
			}
		}
		
    }
	
	//gets the user_type(text) given user_type id as argument
	function get_user_type($user_type)
	{
		$this->db->select('displayed_user_type');
		$this->db->from('user_types');
		$this->db->where('user_type_id',$user_type);
		
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$row = $query->result_array();
			return $row[0]['displayed_user_type'];	
		}
		else
			return "Default User";	
	}
	
	//gets the date a user joined/was created given user_id code as argument
	function get_date_joined($user_id)
	{
		$this->db->select('date_created');
		$this->db->from('users');
		$this->db->where('user_id',$user_id);
		
		$query = $this->db->get();
		if($query->num_rows()==1)
		{
			$row = $query->result_array();
			$date_joined = date("M. Y",$row[0]['date_created']);
			return $date_joined;
		}
		else
			$date_joined = date("M. Y");
			return $date_joined;	
	}
	
	//this function returns the full name of the user
	function get_full_name($user_id)
	{
		$this->db->select('name');
		$this->db->from('users');
		$this->db->where('user_id',$user_id);
		
		$query = $this->db->get();
		if($query->num_rows() ==1)
		 {
			 $row = $query->result();
			 return $row[0]->name;
		 }
		 else
		 {
			 return NULL;
		 }
			
	 }	
	 
	 //this function returns the first name of the user
	  function get_first_name($user_id)
	  {
		  $this->db->select('first_name');
		  $this->db->from('users');
		  $this->db->where('user_id',$user_id);
		  
		  $query = $this->db->get();
		  if($query->num_rows() ==1)
		   {
			   $row = $query->result();
			   return $row[0]->first_name;
		   }
		   else
		   {
			   return NULL;
		   }
			  
	   }
	   
	   //function to insert default permissions into database
	   function default_permissions($id, $corp_id, $type)
	   {
		  switch($type)
		  {
			  case 'corporation':
			  
				 $sqlQuery = "SELECT '$id' as corporation_id, menu, sub_menu FROM corporations_default_permissions";
				 $result = $this->db->query($sqlQuery);
				 
				 foreach($result->result_array() as $key => $row)
				 {
					 $this->insert_data('corporation_modules',$row);
				 }
				 	
			  	break;
				
			  case 'admin':
			  
				 $sqlQuery = "SELECT '$id' as user_id, menu, sub_menu FROM corporation_modules WHERE corporation_id = $corp_id";
				 $result = $this->db->query($sqlQuery);
				 
				 foreach($result->result_array() as $key => $row)
				 {
					 $this->insert_data('menu_control',$row);
				 }
				 
			  	break;

			  case 'staff':
			  
			  	 $sqlQuery = "SELECT '$id' as user_id, menu, sub_menu FROM default_permissions WHERE user_type = 3 AND corporation_id = $corp_id";
				 $result = $this->db->query($sqlQuery);
				 
				 foreach($result->result_array() as $key => $row)
				 {
					 $this->insert_data('menu_control',$row);
				 }
				 
			  	break;

			  case 'member':
			  
			  	 $sqlQuery = "SELECT '$id' as user_id, menu, sub_menu FROM default_permissions  WHERE user_type = 4 AND corporation_id = $corp_id";
				 $result = $this->db->query($sqlQuery);
				 
				 foreach($result->result_array() as $key => $row)
				 {
					 $this->insert_data('menu_control',$row);
				 }
				 
			  	break;

		  }
	   }
	   
	//this function fetches members for the specified corporation
	//$query = SELECT * FROM users WHERE user_type=4 AND corporation_id = $corp_id
	function fetch_relevant_members($corp_id)
	{
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where('user_type',4);
		$this->db->where('corporation_id',$corp_id);
		$query = $this->db->get();
		if($query->num_rows()>0)
		{
			return $query->result_array();
		} 
		else
		{
			return NULL;
		}	
	}	
}
?>