<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//model for handling menu options visible for users and menu permissions control
class Menu_control extends CI_Model {

    function __construct()
    {
       parent::__construct();
    }
	
	private function get_relevant_parent_id($user_id)
	{
		//SELECT menu FROM menu_control WHERE user_id = $user_id
		$where = "sub_menu !='' OR sub_menu != NULL";
		$this->db->select('menu');
		$this->db->where('user_id',$user_id);
		$this->db->where($where);
		$this->db->from('menu_control');
		$query = $this->db->get();
		
		
		$parent_id = $query->result_array();
		
		return $parent_id;
			
	}

	function get_menu($user_id)
	{
		//select * from menu where id={$parent_id} order by position.
		$parent_id = $this->get_relevant_parent_id($user_id);
		$parentIDs ='';
		$countAllItems = count($parent_id);
		for($i=0;$i<$countAllItems;$i++)
		{
			$parentIDs .= $parent_id[$i]['menu'].',';
		}
		
		$parentIDs = chop($parentIDs,",");
		$this->db->select('*');
		$this->db->from('menu');
		$this->db->where('id IN('.$parentIDs.')');
		$this->db->order_by('position','asc');
		$query=$this->db->get();
		if($query->num_rows()>0)
		{
			$menu = $query->result_array();
			$menuCount = count($menu);
			$htmldata ="";
			for($j=0;$j<$menuCount;$j++)
			{
				$htmldata .= "          
				<li class=\"treeview\">
				  <a href=\"#\">
					<i class=\"".$menu[$j]['font_awesome_icon']."\"></i>
					<span>".$menu[$j]['menu_name']."</span>
					<i class=\"fa fa-angle-left pull-right\"></i>
				  </a>";
				  $sub_menu = $this->get_submenu($user_id,$menu[$j]['id']);
				  if($sub_menu != NULL)
				  {
					  $htmldata .= "<ul class=\"treeview-menu\">";
					  foreach($sub_menu as $key=>$value)
					  {
						$htmldata .= " 					
							<li><a href=\"". site_url().$sub_menu[$key]['link']."\"><i class=\"fa fa-circle-o\"></i>".$sub_menu[$key]['submenu_name']."</a></li>";
					  }
					 $htmldata .= "</ul>";
				  }
				 $htmldata .= "</li>";
				
			}
			return $htmldata;
		}
		else return NULL;

	}
	
	//function to fetch the allowed submenu items
 	private function get_relevant_submenu($user_id,$menu_id)
	{
		//$query = "SELECT sub_menu FROM menu_control WHERE user_id=$user_id AND menu=$menu_id";		
		$this->db->select('sub_menu');
		$this->db->where('user_id',$user_id);
		$this->db->where('menu',$menu_id);
		$this->db->from('menu_control');
		$query = $this->db->get();
		
		if($query->num_rows()>0)
		{
			return $query->result_array();

		}
		else return NULL;
	}
	
	//select * from sub_menu where id IN($sub_menu) order by position
	function get_submenu($user_id,$menu_id)
	{
		$submenu_array = $this->get_relevant_submenu($user_id,$menu_id);
		
		$this->db->select('*');
		$this->db->from('sub_menu');
		$this->db->where('id IN('.$submenu_array[0]['sub_menu'].')');
		$this->db->order_by('position','asc');
		
		$query=$this->db->get();
		if($query->num_rows()>0)
		{
			return $query->result_array();

		}
		else return NULL;
	}

}


?>