<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payments_model extends CI_Model {

	function __construct()
    {
     parent::__construct();		
	
    }

	//this function returns the member's no. and name after an Ajax call from process_payments
	//$query = SELECT member_no,name FROM users WHERE user_id = $user_id
	function get_member_details($user_id=1)
	{
		$this->db->select('member_no,name');
		$this->db->from('users');
		$this->db->where('user_id',$user_id);
		$query = $this->db->get();
		
		if($query->num_rows()==1)
		{
			$row = $query->result_array();	
			return json_encode($row);
		}
		else
		{
			return NULL;	
		}
	}
	//this function uses transaction to insert payment into several tables. table payments saves comprehensive data 
	//then individual tables saves the corresponding data
	 function process_payment_trans($form_data)
	 {
		 $form_data = $form_data;
		 $form_data_values = array_values($form_data);
		 list($transaction_id, $user_id, $reg_fee, $share_capital, $service_charge, $loan_repay,$interest, $loan_penalty, $default_penalty, $withdrawal_fee, $total, $date_time, $authorisor) = $form_data_values;
		  //start the transaction
		 $this->db->trans_start();
		  
		 $this->db->insert('payments',$form_data);
		 $insert_id = $this->db->insert_id();
		 if($reg_fee !=0)
		 {
			$query ="INSERT INTO registration_fee (transaction_id,subject_id,amount,date_time) VALUES($transaction_id, $user_id, $reg_fee, $date_time)";
			$this->db->query($query);	 
		 }
		 if($share_capital !=0 || $service_charge !=0)
		 {
			$share_capital = empty($share_capital)?0:$share_capital;
			$service_charge = empty($service_charge)?0:$service_charge;
			
			$query ="INSERT INTO contributions (transaction_id,subject_id,shares,service_charge,date_time) VALUES($transaction_id, $user_id, $share_capital, $service_charge, $date_time)";
			$this->db->query($query);	 
		 }
		  if($loan_repay !=0 || $interest !=0)
		 {
			$loan_repay = empty($loan_repay)?0:$loan_repay;
			$interest = empty($interest)?0:$interest;
			
			$query ="INSERT INTO loan_repayment (transaction_id,subject_id,loan_repay,interest,date_time) VALUES($transaction_id, $user_id, $loan_repay,$interest, $date_time)";
			$this->db->query($query);	 
		 }
		 if($loan_penalty !=0)
		 {
			$query ="INSERT INTO loan_default_penalty (transaction_id,subject_id,amount,date_time) VALUES($transaction_id, $user_id, $loan_penalty, $date_time)";
			$this->db->query($query);	 
		 }
		 if($default_penalty !=0)
		 {
			$query ="INSERT INTO contribution_default_penalty (transaction_id,subject_id,amount,date_time) VALUES($transaction_id, $user_id, $default_penalty, $date_time)";
			$this->db->query($query);	 
		 }
		 if($withdrawal_fee !=0)
		 {
			$query ="INSERT INTO withdrawal (transaction_id,subject_id,amount,date_time) VALUES($transaction_id, $user_id,$withdrawal_fee, $date_time)";
			$this->db->query($query);	 
		 }
		 
		  //make transaction complete
        $this->db->trans_complete();
        //check if transaction status TRUE or FALSE
        if ($this->db->trans_status() === FALSE) {
            //if something went wrong, rollback everything
            $this->db->trans_rollback();
        return FALSE;
        } else {
            //if everything went right, commit the data to the database
            $this->db->trans_commit();
            return $insert_id;
        }
	 }
	 
	 //this function fetches all details for a give payment transaction- takes transaction_id as the parameter
	 function get_transaction_details($transaction_id)
	 {
		 $this->db->select('*');
		 $this->db->from('payments');
		 $this->db->where('transaction_id',$transaction_id);
		 
		 $query = $this->db->get();
		 
		 if($query->num_rows() ==1)
		 {
			 $row = $query->result();
			 return $row;
		 }
		 else
		 {
			 return NULL;
		 }
		 
	 }
	 
	 //inserts monthly contribution for diversity into payments table and contributions table
	 function process_diversity_payment($form_data)
	 {
		 $form_data = $form_data;
		 $form_data_values = array_values($form_data);
		 list($transaction_id, $user_id, $share_capital,$total, $date_time, $time_recorded,$authorisor) = $form_data_values;
		  //start the transaction
		 $this->db->trans_start();
		  
		 $this->db->insert('payments',$form_data);
		 $insert_id = $this->db->insert_id();
		 
		 $query ="INSERT INTO contributions (transaction_id,subject_id,shares,date_time,time_recorded) VALUES($transaction_id, $user_id, $share_capital, $date_time,$time_recorded)";
		 $this->db->query($query);
		 		 
		//make transaction complete
        $this->db->trans_complete();
        //check if transaction status TRUE or FALSE
        if ($this->db->trans_status() === FALSE) 
		{
            //if something went wrong, rollback everything
            $this->db->trans_rollback();
        	return FALSE;
        }
		else 
		{
            //if everything went right, commit the data to the database
            $this->db->trans_commit();			
            return $insert_id;
        }
	 }
	 
	 function fetch_member_payments($user_id)
	 {
		 $sqlQuery = "SELECT transaction_id,user_id,share_capital,date_time 
		 			  FROM payments WHERE user_id = {$user_id} 
					  ORDER BY date_time ASC";
		 $query = $this->db->query($sqlQuery);
		 
		 if($query->result_array())
		 {
		 	return $query->result_array();
		 }
		 else
		 {
			 return NULL;
		 }
	 }
}
?>