      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
          <h1>
           View Projects
          </h1>
          <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="#">Expenditure</a></li>
            <li class="active">View Projects</li>
          </ol>
        </section>

        <!-- Main content -->
        <section class="content">
           <div class="row">         
           
           	 <div class="col-md-12">
              <div class="box box-success">
                <div class="box-header with-border">
                  <h3 class="box-title purple" style="font-weight:600;">List of Projects(click to see details)</h3>                  
                </div><!-- /.box-header -->  
              <div class="box-body">
                 	<div class="row header_blue header-title" style="margin:2px; font-size:14px;">
                    	<div class="col-sm-3">Project Name</div>
                        <div class="col-sm-3">Total Amount</div>
                        <div class="col-sm-3">Amount Per Member</div>
                        <div class="col-sm-3">Due Date</div>
                    </div>
                    <?php
						$bgfill = null;
						$whitebg = "#fff";
		  				$greybg = "#999"; 
						if ($projects !=null)
							foreach($projects as $project)
								{
									if($bgfill)
									   $bgcolor = $whitebg;
									else
									   $bgcolor = $greybg;
					?>
                                    <div class="row" style='background-color:<?php echo $bgcolor;?>; margin:2px' onclick="toggleDT('<?php echo "investment".$project['id']; ?>')">
                                    <!--<div class="col-sm-12">-->
                                        <div class="col-sm-3"><?php echo $project['investment_name']; ?></div>
                                        <div class="col-sm-3"><?php echo $project['total_amount']; ?></div>
                                        <div class="col-sm-3"><?php echo $project['amount_per_member']; ?></div>
                                        <div class="col-sm-3"><?php echo date("M Y",$project['due_date']); ?></div>
                                    <!--</div>-->
                                    </div>
                                    
                                    <!--DataTable for contribution breakdown-->
                                    <div class="row" id="<?php echo "investment".$project['id']; ?>" style="display:none; margin:15px;"> 
                                     <div class="col-md-12">
                                      <div class="box box-primary">
                                        <div class="box-header with-border">
                                          <h3 class="box-title header_blue"><?php echo $project['investment_name']; ?> Breakdown</h3>                  
                                        </div><!-- /.box-header -->  
                                      <div class="box-body">
                                      
                                      
                                        <table id="<?php echo "dataTable".$project['id']; ?>" class="table table-bordered table-striped">                    
                                        <thead>
                                            <tr>
                                                <th>S No.</th>
                                                <th>Project</th>
                                                <th>Name</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                                <?php
                                                $user_type = $this->login_model->user_type();
                                                 if($user_type == 2)
                                                    echo "<td>Action</td>";
                                                ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach($investment[$project['id']] as $val){
										
										$id = $val['id'];	
                                        ?>
                                        <!-- Start: list_row -->
                                            <tr>
                                                <td><?php echo $val['id'];?></td>
                                                <td><?php echo $project['investment_name'];?></td>
                                                <td><?php echo $this->main_model->get_full_name($val['user_id']);?></td>
                                                <td><?php echo $val['amount'];?></td>
                                                <td><?php echo $status = ($val['status'] !=1)?"<span class='red' id='status{$val['id']}'>Not Paid</span>":"<span class='green'>Paid</span>";?></td>
                                                <?php if($user_type == 2)
                                                echo "<td>
                                                        <a href='javascript:void(0)' onclick = 'check_investment($id);'>
                                                            <span class='green'><i class='fa fa-check'></i></span>
                                                        </a>
                                                    </td>";
                                                ?>
                                            </tr>
                                          <?php  } ?>
                                        
                                        <!-- End: list_row -->
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <tr>
                                                <th>S No.</th>
                                                <th>Project</th>
                                                <th>Name</th>
                                                <th>Amount</th>
                                                <th>Status</th>
                                                <?php if($user_type == 2)
                                                echo "<th>Action</th>";
                                                ?>
                                            </tr>
                                            </tr>
                                        </tfoot>
                                    </table>
                                      
                                                              
                                        </div><!-- /closing outer box --> 
                                        </div><!-- /.box -->   
                                    </div> <!-- /.col-md-12 -->
                                  </div>   <!-- /.row -->
                   			 <?php 
							 		$bgfill = ! $bgfill;
									}
							 ?>
                             
                    
                </div><!-- /closing outer box --> 
                </div><!-- /.box -->   
           	</div>
          </div>   <!-- /.row -->

        </section><!-- /.content -->
      </div><!-- /.content-wrapper -->
      
      <script type="text/javascript">
	  	
			function check_investmentForJAlert(id)
			{
				  var id = id;					  					  
				  var form_data = {'id': id};					  
				  console.log(form_data);
				  $.ajax({ 
					  type 		: 'POST',
					  url 		: url+'expenditure/check_investment', 
					  data 		: form_data,
					  success 	: function(data) 
								  {	
									 $('#status'+id).removeClass('red').addClass('green').text('Paid');						
								  }
				  });	
			}
			
			function check_investment(id)
			  {
					var user_id = id;
					$.jAlert({
						'title': 'Change Investment Status',
						'content': 'Are you sure you want to mark the Investment as paid?',
						'theme': 'blue',
						'size': 'sm',
						'showAnimation': 'fadeInUp',
						'hideAnimation': 'fadeOutDown',
						'btns': {
									'text': 'Mark As Paid',
									'theme': 'green',
									'onClick': function(e,btn){e.preventDefault();check_investmentForJAlert(id);}
								  }
						 
				   });					  
			  }
			  
			  function toggleDT(toggleDiv)
			  { 			  	 
				  $("#"+toggleDiv).toggle(1000);
			  }
	  </script>