<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>Sacco Manager | Dashboard</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.4 -->
    <link href="<?php echo base_url();?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- FontAwesome 4.3.0 -->
    <link href="<?php echo base_url();?>plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <!-- Ionicons 2.0.0 -->
    <!--<link href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css" rel="stylesheet" type="text/css" />-->
    <!-- Theme style -->
    <link href="<?php echo base_url();?>dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
    <!-- AdminLTE Skins. Choose a skin from the css/skins
         folder instead of downloading all of them to reduce the load. -->
    <link href="<?php echo base_url();?>dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url();?>dist/css/custom-styles.css" rel="stylesheet" type="text/css" />
    
    <!--jQuery moved to topbar so that it will be loaded first to allow adding jQuery dependent code in content.php-->
    <!-- jQuery 2.1.4 -->
    <script src="<?php echo base_url();?>plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo base_url();?>plugins/jQueryUI/jquery-ui.min.js" type="text/javascript"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script type="text/javascript">
      $.widget.bridge('uibutton', $.ui.button);
    </script>    
	<?php 
	  if($additional_css !=NULL)
	  {
		$css_prefix = '<link href="';
		$css_suffix = 'rel="stylesheet" type="text/css" />';
			foreach($additional_css as $key=>$val)
				{
					echo $css_prefix.base_url("$val")." ".$css_suffix;
				}
	  }
	  //used in functions below too get user profile information
		$user_id = $this->login_model->user_id();
		$user_type = $this->login_model->user_type();
	 ?>
 
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    
  <!-- Google Analytics-->    
     <script>
	  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
	  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
	  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
	
	  ga('create', 'UA-74364875-1', 'auto');
	  ga('send', 'pageview');
	  
	  <!--sets the url to be used by scripts-->
	  //var url = "http://localhost/saccomanager/";
	  //server url:note search for www occurrence
	  var str = window.location.href;
	  if(str.search(/www/i)==-1)
	  {
		  var url = "http://saccomanager.com/";	
	  }
	  else
	  {
		  var url = "http://www.saccomanager.com/";	
	  }
	
	</script>
  </head>
  <body class="skin-blue sidebar-mini">
    <div class="wrapper">

      <header class="main-header">
        <!-- Logo -->
        <a href="#" class="logo">
          <!-- mini logo for sidebar mini 50x50 pixels -->
          <span class="logo-mini"><b><?php echo $this->login_model->short_name();?></b></span>
          <!-- logo for regular state and mobile devices -->
          <span class="logo-lg"><b><?php echo $this->login_model->corporation_name();?></b></span>
        </a>
        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation">
          <!-- Sidebar toggle button-->
          <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
          </a>
          <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">              
              <!-- User Account: style can be found in dropdown.less -->
              <li class="dropdown user user-menu">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                  <img src="<?php echo base_url();?>images/profile_photos/thumbs/<?php echo $profile_photo;?>" class="user-image" alt="User Image" />
                  <span class="hidden-xs"><?php echo $this->login_model->name();?></span>
                </a>
                <ul class="dropdown-menu">
                  <!-- User image -->
                  <li class="user-header">
                    <img src="<?php echo base_url();?>images/profile_photos/thumbs/<?php echo $profile_photo;?>" class="img-circle" alt="User Image" />
                    <p>
                      <?php echo $this->login_model->name();?> - <?php echo $this->main_model->get_user_type($user_type);?>
                      <small>Member since <?php echo $this->main_model->get_date_joined($user_id);?></small>
                    </p>
                  </li>
                  <!-- Menu Body -->
                  <li class="user-body">
                    <div class="col-xs-7 text-center">
                      <a href="<?php echo site_url(); ?>general/reset_password">Change Password</a>
                    </div>
                    <div class="col-xs-5 text-center">
                      <a href="<?php echo site_url();?>user_management/edit_profile/<?php echo $user_id; ?>">Edit Profile</a>
                    </div> 
                  </li>
                  <!-- Menu Footer-->
                  <li class="user-footer">
                    <div class="pull-left">
                      <?php 
					  $user_type = $this->login_model->user_type();
					  if($user_type == 4)
					  {
						  $profile_page = "user_profile";
					  }
					  else
					  {
						  $profile_page = "staff_profile";
					  }
					  ?>
                      <a href="<?php echo site_url()?>user_management/<?php echo $profile_page; ?>/<?php echo $user_id;?>" class="btn btn-default btn-flat">Profile</a>
                    </div>
                    <div class="pull-right">
                      <a href="<?php echo site_url();?>dashboard/logout" class="btn btn-default btn-flat">Sign out</a>
                    </div>
                  </li>
                </ul>
              </li>
              <!-- Control Sidebar Toggle Button -->
              <li>
                <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
              </li>
            </ul>
          </div>
        </nav>
      </header>