

CREATE TABLE `ci_sessions` (
  `session_id` varchar(40) NOT NULL DEFAULT '0',
  `ip_address` varchar(45) NOT NULL DEFAULT '0',
  `user_agent` varchar(120) NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT '0',
  `user_data` text NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `last_activity_idx` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


INSERT INTO ci_sessions VALUES
("45d5b557814d6c9eeeb2349840241b76","66.249.64.170","Mozilla/5.0 (iPhone; CPU iPhone OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12F70 S","1457922050",""),
("468455bacd4bae048e7941775c1e69d5","66.249.66.19","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1457955664",""),
("47310b4c04c8e4c0760a6b9da41ef5a2","40.76.8.77","semanticbot","1457961236",""),
("53a90b875f75c7195bc86129fff446d5","105.161.251.159","Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36","1457927449",""),
("5cbfa60cca6491d1ffda7f34f683e096","197.232.39.101","Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36","1457942555",""),
("7c1b9a7953f1c5a41c2c7d3b12b5a35d","66.249.93.93","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1457947841",""),
("91c0a9fd7f74c47a9eb48f1540ebcbe5","66.249.93.89","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1457928388",""),
("be35fae5ae354c0df20d05d8c80f987c","184.73.88.240","Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3 GTB6 (.NET CLR 3.5.30729)","1457929396",""),
("cd28a22e178cb36ff1ecd7ac6a6f3c9c","197.232.39.101","Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36","1457968101","");




CREATE TABLE `contribution_default_penalty` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;


INSERT INTO contribution_default_penalty VALUES
("1","20","25","7","0"),
("2","21","5","80","1442308253"),
("3","75","25","200","1442924250"),
("4","76","25","200","1442924361"),
("5","77","25","200","1442924521"),
("6","78","25","200","1442924558"),
("7","79","25","200","1442924583"),
("8","80","25","200","1442924630"),
("9","81","25","200","1442924676"),
("10","82","25","200","1442924749");




CREATE TABLE `contributions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `shares` int(10) NOT NULL,
  `service_charge` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  `time_recorded` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=latin1;


INSERT INTO contributions VALUES
("1","1","3","500","0","1392411600","1455549525"),
("2","2","4","500","0","1392411600","1455549587"),
("3","3","5","500","0","1392411600","1455551636"),
("4","4","6","500","0","1392411600","1455551648"),
("5","5","7","500","0","1392411600","1455551656"),
("6","6","8","500","0","1392411600","1455551665"),
("7","7","9","500","0","1392411600","1455551673"),
("8","8","3","500","0","1394830800","1455552095"),
("9","9","4","500","0","1394830800","1455552261"),
("10","10","5","500","0","1394830800","1455552270"),
("11","11","6","500","0","1394830800","1455552276"),
("12","12","7","500","0","1394830800","1455552280"),
("13","13","8","500","0","1394830800","1455552285"),
("14","14","9","500","0","1394830800","1455552290"),
("15","15","3","500","0","1397509200","1455552373"),
("16","16","4","500","0","1397509200","1455552377"),
("17","17","5","500","0","1397509200","1455552382"),
("18","18","6","500","0","1397509200","1455552385"),
("19","19","7","500","0","1397509200","1455552389"),
("20","20","8","500","0","1397509200","1455552393"),
("21","21","9","500","0","1397509200","1455552401"),
("22","22","3","500","0","1400101200","1455552473"),
("23","23","4","500","0","1400101200","1455552477"),
("24","24","5","500","0","1400101200","1455552483"),
("25","25","6","500","0","1400101200","1455552487"),
("26","26","7","500","0","1400101200","1455552494"),
("27","27","8","500","0","1400101200","1455552499"),
("28","28","9","500","0","1400101200","1455552503"),
("29","29","3","1000","0","1402779600","1455552661"),
("30","30","4","1000","0","1402779600","1455552665"),
("31","31","5","1000","0","1402779600","1455552669"),
("32","32","6","1000","0","1402779600","1455552674"),
("33","33","7","1000","0","1402779600","1455552687"),
("34","34","8","1000","0","1402779600","1455552691"),
("35","35","9","1000","0","1402779600","1455552697"),
("36","36","3","1000","0","1405371600","1455552987"),
("37","37","4","1000","0","1405371600","1455552990"),
("38","38","5","1000","0","1405371600","1455553002"),
("39","39","6","1000","0","1405371600","1455553009"),
("40","40","7","1200","0","1405371600","1455553019"),
("41","41","8","1000","0","1405371600","1455553024"),
("42","42","9","1000","0","1405371600","1455553028"),
("43","43","3","1000","0","1408050000","1455553088"),
("44","44","4","1000","0","1408050000","1455553093"),
("45","45","5","1000","0","1408050000","1455553097"),
("46","46","6","1000","0","1408050000","1455553103"),
("47","47","7","1000","0","1408050000","1455553106"),
("48","48","8","1000","0","1408050000","1455553109"),
("49","49","9","1000","0","1408050000","1455553113"),
("50","50","3","1000","0","1410728400","1455702444"),
("51","51","4","1000","0","1410728400","1455702448"),
("52","52","5","1000","0","1410728400","1455702452"),
("53","53","6","1000","0","1410728400","1455702457"),
("54","54","7","1000","0","1410728400","1455702463"),
("55","55","8","1000","0","1410728400","1455702468"),
("56","56","9","1000","0","1410728400","1455702472"),
("57","57","3","1000","0","1413320400","1455702799"),
("58","58","4","1000","0","1413320400","1455702803"),
("59","59","5","1000","0","1413320400","1455702808"),
("60","60","6","1000","0","1413320400","1455702812"),
("61","61","7","1000","0","1413320400","1455702838"),
("62","62","8","1000","0","1413320400","1455702841"),
("63","63","9","1000","0","1413320400","1455702846"),
("64","64","3","1000","0","1415998800","1455702995"),
("65","65","4","1000","0","1415998800","1455702999"),
("66","66","5","1000","0","1415998800","1455703003"),
("67","67","6","1000","0","1415998800","1455703010"),
("68","68","7","1000","0","1415998800","1455703015"),
("69","69","8","1000","0","1415998800","1455703018"),
("70","70","9","1000","0","1415998800","1455703023"),
("71","71","3","1000","0","1418590800","1455703101"),
("72","72","4","1000","0","1418590800","1455703104"),
("73","73","5","1000","0","1418590800","1455703108"),
("74","74","6","1000","0","1418590800","1455703155"),
("75","75","7","1000","0","1418590800","1455703159"),
("76","76","8","1000","0","1418590800","1455703162"),
("77","77","9","1000","0","1418590800","1455703167"),
("78","78","3","1000","0","1421269200","1455703373"),
("79","79","4","1000","0","1421269200","1455703378"),
("80","80","5","1500","0","1421269200","1455703389"),
("81","81","6","1000","0","1421269200","1455703393"),
("82","82","7","1000","0","1421269200","1455703397"),
("83","83","8","1000","0","1421269200","1455703403"),
("84","84","9","1000","0","1421269200","1455703412"),
("85","85","3","1000","0","1421269200","1455703479"),
("86","86","4","1000","0","1423947600","1455703484"),
("87","87","5","1500","0","1423947600","1455703494"),
("88","88","3","1000","0","1423947600","1455703551"),
("89","89","6","1000","0","1423947600","1455703610"),
("90","90","7","1000","0","1423947600","1455703614"),
("91","91","8","1000","0","1423947600","1455703619"),
("92","92","9","1000","0","1423947600","1455703624"),
("93","93","3","1000","0","1426366800","1455703731"),
("94","94","4","1000","0","1426366800","1455703734"),
("95","95","5","1000","0","1426366800","1455703742"),
("96","96","6","1500","0","1426366800","1455703750"),
("97","97","7","1000","0","1426366800","1455703759"),
("98","98","8","1000","0","1426366800","1455703763"),
("99","99","9","1000","0","1426366800","1455703767"),
("100","100","3","1000","0","1429045200","1455703831");
INSERT INTO contributions VALUES
("101","101","4","1000","0","1429045200","1455703834"),
("102","102","5","1000","0","1429045200","1455703838"),
("103","103","6","1500","0","1429045200","1455703843"),
("104","104","7","1000","0","1429045200","1455703999"),
("105","105","8","1000","0","1429045200","1455704004"),
("106","106","9","1000","0","1429045200","1455704007"),
("107","107","3","1500","0","1431637200","1455719864"),
("108","108","4","1000","0","1431637200","1455719872"),
("109","109","5","1500","0","1431637200","1455719886"),
("110","110","6","1500","0","1431637200","1455719892"),
("111","111","7","1000","0","1431637200","1455719896"),
("112","112","8","1000","0","1431637200","1455719899"),
("113","113","9","1000","0","1431637200","1455719903"),
("114","114","3","2000","0","1434315600","1455720128"),
("115","115","4","2000","0","1434315600","1455720131"),
("116","116","5","2000","0","1434315600","1455720135"),
("117","117","6","2000","0","1434315600","1455720138"),
("118","118","7","2000","0","1434315600","1455720141"),
("119","119","8","2000","0","1434315600","1455720145"),
("120","120","9","2000","0","1434315600","1455720148"),
("121","121","3","2000","0","1436907600","1455720196"),
("122","122","4","2000","0","1436907600","1455720254"),
("123","123","5","2000","0","1436907600","1455720259"),
("124","124","6","2000","0","1436907600","1455720262"),
("125","125","7","2000","0","1436907600","1455720265"),
("126","126","8","2000","0","1436907600","1455720269"),
("127","127","9","2000","0","1436907600","1455720273"),
("128","128","3","2000","0","1439586000","1455720349"),
("129","129","4","2000","0","1439586000","1455720352"),
("130","130","5","2000","0","1439586000","1455720355"),
("131","131","6","3000","0","1439586000","1455720363"),
("132","132","7","2000","0","1439586000","1455720366"),
("133","133","8","2000","0","1439586000","1455720371"),
("134","134","9","2000","0","1439586000","1455720374"),
("135","135","3","2000","0","1442264400","1455720412"),
("136","136","4","2000","0","1442264400","1455720415"),
("137","137","5","3000","0","1442264400","1455720424"),
("138","138","6","3000","0","1442264400","1455720431"),
("139","139","7","2000","0","1442264400","1455720436"),
("140","140","8","3000","0","1442264400","1455720442"),
("141","141","9","2000","0","1442264400","1455720445"),
("142","142","3","2500","0","1444856400","1455720480"),
("143","143","4","2000","0","1444856400","1455720488"),
("144","144","5","4000","0","1444856400","1455720498"),
("145","145","6","4500","0","1444856400","1455720516"),
("146","146","7","2000","0","1444856400","1455720523"),
("147","147","8","2000","0","1444856400","1455720527"),
("148","148","9","2000","0","1444856400","1455720530"),
("149","149","3","10000","0","1447534800","1455720577"),
("150","150","4","12000","0","1447534800","1455722029"),
("151","151","5","5000","0","1447534800","1455722043"),
("152","152","6","7000","0","1447534800","1455722131"),
("153","153","7","4800","0","1447534800","1455722144"),
("154","154","8","3000","0","1447534800","1455722157"),
("155","155","9","2000","0","1447534800","1455722257"),
("156","156","3","6000","0","1450126800","1455722659"),
("157","157","4","5000","0","1450126800","1455722677"),
("158","158","5","7500","0","1450126800","1455722691"),
("159","159","6","4000","0","1450126800","1455722701"),
("160","160","7","12000","0","1450126800","1455722714"),
("161","161","8","13000","0","1450126800","1455722729"),
("162","162","9","15000","0","1450126800","1455722738"),
("163","163","3","2000","0","1452805200","1455722768"),
("164","164","4","2000","0","1452805200","1455722772"),
("165","165","5","2000","0","1452805200","1455722776"),
("166","166","6","2000","0","1452805200","1455722796"),
("167","167","7","2000","0","1452805200","1455722799"),
("168","168","8","2000","0","1452805200","1455722803"),
("169","169","9","2000","0","1452805200","1455722806"),
("170","170","5","3000","0","1454619600","1456763311"),
("171","171","5","3000","0","1457179200","1456765146"),
("172","172","3","2000","0","1456347600","1456765173"),
("173","173","4","2000","0","1456002000","1456765349"),
("174","174","7","2000","0","1456261200","1456765394"),
("175","175","8","2000","0","1456347600","1456765414"),
("176","176","6","2000","0","1454274000","1456765479");




CREATE TABLE `corporation_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `corporation_id` int(5) NOT NULL,
  `menu` int(2) NOT NULL,
  `sub_menu` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;


INSERT INTO corporation_modules VALUES
("1","2","1","1,2,11,12"),
("2","2","2","9,10,18,19"),
("3","2","8","20,21,24"),
("4","2","4","25,26"),
("6","2","9","27,28,29"),
("7","2","6","30,31,32");




CREATE TABLE `corporations` (
  `corporation_id` int(3) NOT NULL AUTO_INCREMENT,
  `corporation_name` varchar(100) NOT NULL,
  `short_name` varchar(20) NOT NULL,
  `date_created` bigint(20) NOT NULL,
  `address` varchar(30) DEFAULT NULL,
  `phone_no` varchar(15) NOT NULL,
  `logo` varchar(50) NOT NULL,
  PRIMARY KEY (`corporation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;


INSERT INTO corporations VALUES
("1","Ideal Software Applications","ISA","1441487544","710 - 00900 Kiambu","+254723897065",""),
("2","Diversity Holdings LTD ","Diversity","1455548104","50218-00200 Nairobi","+254723897065","default_logo.jpg");




CREATE TABLE `corporations_default_permissions` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `menu` int(2) NOT NULL,
  `sub_menu` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;


INSERT INTO corporations_default_permissions VALUES
("1","1","1,2,11,12"),
("2","2","9,10,18,19"),
("3","8","21");




CREATE TABLE `default_permissions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `corporation_id` int(3) NOT NULL,
  `user_type` int(2) NOT NULL,
  `menu` int(2) NOT NULL,
  `sub_menu` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;


INSERT INTO default_permissions VALUES
("1","2","4","1","11,12"),
("2","2","4","2","10"),
("3","2","4","4","25");




CREATE TABLE `expenditure` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `investment_name` varchar(50) NOT NULL,
  `total_amount` int(10) NOT NULL,
  `amount_per_member` int(10) NOT NULL,
  `due_date` bigint(15) NOT NULL,
  `date_created` bigint(15) NOT NULL,
  `authorisor` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;


INSERT INTO expenditure VALUES
("1","Company Registration","20000","2857","1449867600","1457437964","10"),
("2","Ujenzi Plot","300000","42857","1452805200","1457448385","10"),
("3","Title Deed","12000","1714","1461531600","1457449933","2");




CREATE TABLE `external_password_reset` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `national_id_no` int(10) NOT NULL,
  `request_time` bigint(15) NOT NULL,
  `request_ip` varchar(30) NOT NULL,
  `email_address` varchar(50) NOT NULL,
  `session_id` varchar(30) NOT NULL,
  `session` varchar(50) NOT NULL,
  `link` varchar(120) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `link_use_time` bigint(15) DEFAULT NULL,
  `link_use_ip` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;






CREATE TABLE `guarantor_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL,
  `guarantor_id` int(10) NOT NULL,
  `old_status` int(2) NOT NULL,
  `new_status` int(2) NOT NULL,
  `authorisor` int(10) NOT NULL,
  `time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `guarantor_status` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;


INSERT INTO guarantor_status VALUES
("1","Pending Verification"),
("2","Verified"),
("3","Rejected"),
("4","Active"),
("5","Free");




CREATE TABLE `guarantors` (
  `guarantor_id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `guarantor_member_no` varchar(20) NOT NULL,
  `guarantor_id_no` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`guarantor_id`),
  KEY `loan_id` (`loan_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `guarantors_ibfk_1` FOREIGN KEY (`loan_id`) REFERENCES `loan_application` (`loan_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `guarantors_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `investment_payments` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `investment_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `status` varchar(30) NOT NULL,
  `date_checked` bigint(20) DEFAULT NULL,
  `authorisor` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;


INSERT INTO investment_payments VALUES
("1","1","3","2857","1","1457538408","10"),
("2","1","4","2857","1","1457537957","10"),
("3","1","5","2857","1","1457538005","10"),
("4","1","6","2857","1","1457538092","10"),
("5","1","7","2857","1","1457538291","10"),
("6","1","8","2857","1","1457538298","10"),
("7","1","9","2857","1","1457603742","10"),
("8","2","3","42857","1","1457622007","10"),
("9","2","4","42857","1","1457622010","10"),
("10","2","5","42857","1","1457622013","10"),
("11","2","6","42857","1","1457622017","10"),
("12","2","7","42857","1","1457622020","10"),
("13","2","8","42857","1","1457622022","10"),
("14","2","9","42857","1","1457622026","10"),
("15","3","3","1714","0","",""),
("16","3","4","1714","0","",""),
("17","3","5","1714","0","",""),
("18","3","6","1714","0","",""),
("19","3","7","1714","0","",""),
("20","3","8","1714","0","",""),
("21","3","9","1714","0","","");




CREATE TABLE `lipisha_payments` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `amount` int(10) NOT NULL,
  `type` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  `paybill` int(10) NOT NULL,
  `account_number` int(10) NOT NULL,
  `account_name` varchar(50) NOT NULL,
  `reference` varchar(20) NOT NULL,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;


INSERT INTO lipisha_payments VALUES
("12","2015-10-03 16:32:11","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","2350","2350","2350","2350","2350","2350"),
("13","2015-10-03 16:34:53","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","2350","2350","2350"),
("14","2015-10-03 16:36:58","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","2B55AB592","2350"),
("15","2015-10-03 16:43:39","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","2270E6978","2350"),
("16","2015-10-03 16:46:50","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","D27A00D0D","Pending"),
("17","2015-10-03 16:50:40","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","AE5BC2F1D","Pending"),
("18","2015-10-03 16:52:05","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","3940BE4E9","Pending"),
("19","2015-10-03 16:56:06","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","15D3C5BA0","Pending Approval"),
("20","2015-10-03 17:00:07","2350","Payment","M-Pesa","FRANCIS KELVIN MARSHALL","254713384482","","961700","614","kenneth Njoroge","A4D102FD2","OK");




CREATE TABLE `loan_application` (
  `loan_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `principal` int(10) NOT NULL,
  `repayment_duration` int(5) NOT NULL,
  `purpose` text NOT NULL,
  `date_applied` bigint(20) NOT NULL,
  `applicant_id` int(10) NOT NULL,
  `status` int(3) NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  CONSTRAINT `loan_application_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `loan_application_ibfk_2` FOREIGN KEY (`status`) REFERENCES `loan_status` (`loan_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `loan_default_penalty` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;


INSERT INTO loan_default_penalty VALUES
("1","20","25","6","0"),
("2","21","5","60","1442308253"),
("3","75","25","250","1442924250"),
("4","76","25","250","1442924361"),
("5","77","25","250","1442924521"),
("6","78","25","250","1442924558"),
("7","79","25","250","1442924583"),
("8","80","25","250","1442924630"),
("9","81","25","250","1442924676"),
("10","82","25","250","1442924749"),
("11","86","25","555","1442928187"),
("12","95","5","760","1448650792");




CREATE TABLE `loan_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL,
  `old_status` int(2) NOT NULL,
  `new_status` int(2) NOT NULL,
  `authorisor` int(10) NOT NULL,
  `time_changed` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `loan_repayment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `loan_repay` int(20) NOT NULL,
  `interest` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;


INSERT INTO loan_repayment VALUES
("1","20","25","4","5","0"),
("2","21","5","40","50","1442308253"),
("3","29","5","5000","0","1442700856"),
("4","30","5","5000","0","1442703017"),
("5","48","25","0","5656","1442844761"),
("6","58","5","43413","0","1442849940"),
("7","59","5","43413","0","1442850124"),
("8","67","25","3000","300","1442922915"),
("9","74","5","5000","320","1442924091"),
("10","75","25","4000","450","1442924250"),
("11","76","25","4000","450","1442924361"),
("12","77","25","4000","450","1442924521"),
("13","78","25","4000","450","1442924558"),
("14","79","25","4000","450","1442924583"),
("15","80","25","4000","450","1442924630"),
("16","81","25","4000","450","1442924676"),
("17","82","25","4000","450","1442924749"),
("18","88","5","5900","0","1442928398"),
("19","89","25","5000","2365","1444563889"),
("20","90","5","3578","578","1445613520"),
("21","91","25","5858","8548","1445891732"),
("22","92","25","55","0","1447924562"),
("23","93","25","35634","35535","1447925621"),
("24","94","25","3254","0","1447925672"),
("25","95","5","454","5454","1448650792");




CREATE TABLE `loan_status` (
  `loan_status_id` int(3) NOT NULL AUTO_INCREMENT,
  `status_name` varchar(50) NOT NULL,
  PRIMARY KEY (`loan_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;


INSERT INTO loan_status VALUES
("1","Pending Approval"),
("2","Approved"),
("3","Rejected"),
("4","Active"),
("5","Completely Repaid");




CREATE TABLE `login_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `national_id_no` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `date_time` int(15) NOT NULL,
  `ip_address` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=latin1;


INSERT INTO login_history VALUES
("1","26493976","d41d8cd98f00b204e9800998ecf8427e","1456561770","196.102.14.90","SUCCESSFUL"),
("2","26493976","d41d8cd98f00b204e9800998ecf8427e","1456568788","196.102.14.90","SUCCESSFUL"),
("3","","d41d8cd98f00b204e9800998ecf8427e","1456568792","196.102.14.90","UNAUTHORISED_ACCESS"),
("4","","d41d8cd98f00b204e9800998ecf8427e","1456568792","196.102.14.90","UNAUTHORISED_ACCESS"),
("5","26493976","d41d8cd98f00b204e9800998ecf8427e","1456568802","196.102.14.90","SUCCESSFUL"),
("6","26493976","d41d8cd98f00b204e9800998ecf8427e","1456593081","197.180.125.46","SUCCESSFUL"),
("7","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1456602512","196.97.144.89","SUCCESSFUL"),
("8","26493976","d41d8cd98f00b204e9800998ecf8427e","1456607142","196.97.144.89","SUCCESSFUL"),
("9","27836077","d41d8cd98f00b204e9800998ecf8427e","1456762970","197.211.1.154","SUCCESSFUL"),
("10","26493976","d41d8cd98f00b204e9800998ecf8427e","1456762977","197.232.39.101","SUCCESSFUL"),
("11","27836077","d41d8cd98f00b204e9800998ecf8427e","1456765293","197.211.1.154","SUCCESSFUL"),
("12","","d41d8cd98f00b204e9800998ecf8427e","1456765293","197.211.1.154","UNAUTHORISED_ACCESS"),
("13","26493976","d41d8cd98f00b204e9800998ecf8427e","1456766017","197.232.39.101","SUCCESSFUL"),
("14","","d41d8cd98f00b204e9800998ecf8427e","1456767566","197.211.1.154","INACTIVE_ACCOUNT"),
("15","","d41d8cd98f00b204e9800998ecf8427e","1456767575","197.211.1.154","INACTIVE_ACCOUNT"),
("16","","d41d8cd98f00b204e9800998ecf8427e","1456767607","197.211.1.154","INACTIVE_ACCOUNT"),
("17","27836077","d41d8cd98f00b204e9800998ecf8427e","1456767613","197.211.1.154","SUCCESSFUL"),
("18","27836077","d41d8cd98f00b204e9800998ecf8427e","1456767707","197.211.1.154","SUCCESSFUL"),
("19","26493976","ef6e65efc188e7dffd7335b646a85a21","1456830068","197.232.39.101","SUCCESSFUL"),
("20","26493976","9954b51712813877b30d1e5947b30635","1456836072","197.232.39.101","SUCCESSFUL"),
("21","26493976","ef6e65efc188e7dffd7335b646a85a21","1456907993","197.232.39.101","SUCCESSFUL"),
("22","26493976","ef6e65efc188e7dffd7335b646a85a21","1456917245","197.232.39.101","SUCCESSFUL"),
("23","26493976","ef6e65efc188e7dffd7335b646a85a21","1456917631","197.232.39.101","SUCCESSFUL"),
("24","","d41d8cd98f00b204e9800998ecf8427e","1456917635","197.232.39.101","UNAUTHORISED_ACCESS"),
("25","26493976","ef6e65efc188e7dffd7335b646a85a21","1456917648","197.232.39.101","SUCCESSFUL"),
("26","26493976","9954b51712813877b30d1e5947b30635","1456919005","197.232.39.101","SUCCESSFUL"),
("27","","d41d8cd98f00b204e9800998ecf8427e","1456919008","197.232.39.101","UNAUTHORISED_ACCESS"),
("28","26493976","d4827d2ddae225f3bbb16ccc9cf746a9","1456919020","197.232.39.101","WRONG_PASSWORD"),
("29","26493976","9954b51712813877b30d1e5947b30635","1456919032","197.232.39.101","SUCCESSFUL"),
("30","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1456925454","197.232.39.101","SUCCESSFUL"),
("31","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1456927863","197.232.39.101","SUCCESSFUL"),
("32","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1456994278","197.232.39.101","SUCCESSFUL"),
("33","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457007165","197.232.39.101","SUCCESSFUL"),
("34","26493976","ef6e65efc188e7dffd7335b646a85a21","1457007202","197.232.39.101","SUCCESSFUL"),
("35","27836077","b4cc344d25a2efe540adbf2678e2304c","1457008435","197.232.39.101","SUCCESSFUL"),
("36","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457079830","197.232.39.101","SUCCESSFUL"),
("37","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457080577","197.232.39.101","SUCCESSFUL"),
("38","26493976","9954b51712813877b30d1e5947b30635","1457087263","197.232.39.101","SUCCESSFUL"),
("39","","d41d8cd98f00b204e9800998ecf8427e","1457087263","197.232.39.101","UNAUTHORISED_ACCESS"),
("40","26493976","ef6e65efc188e7dffd7335b646a85a21","1457089550","197.232.39.101","SUCCESSFUL"),
("41","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457089563","197.232.39.101","SUCCESSFUL"),
("42","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457098470","197.232.39.101","SUCCESSFUL"),
("43","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457098969","197.232.39.101","SUCCESSFUL"),
("44","","d41d8cd98f00b204e9800998ecf8427e","1457106964","197.232.39.101","UNAUTHORISED_ACCESS"),
("45","26493976","ef6e65efc188e7dffd7335b646a85a21","1457193078","105.50.89.194","SUCCESSFUL"),
("46","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457193430","105.50.89.194","SUCCESSFUL"),
("47","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457193739","105.50.89.194","SUCCESSFUL"),
("48","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457210612","105.163.163.109","SUCCESSFUL"),
("49","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457221134","105.163.163.109","SUCCESSFUL"),
("50","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457221314","105.163.163.109","SUCCESSFUL"),
("51","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457223907","196.201.221.10","SUCCESSFUL"),
("52","27347637","01bbba85d02955b23cbb2be354be2be2","1457239751","197.237.245.31","WRONG_PASSWORD"),
("53","27347637","7daacea5f373b4c1c054158b126d317f","1457239767","197.237.245.31","SUCCESSFUL"),
("54","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457249162","105.52.149.37","SUCCESSFUL"),
("55","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457250278","105.52.149.37","SUCCESSFUL"),
("56","28346023","684c851af59965b680086b7b4896ff98","1457262031","105.231.145.100","SUCCESSFUL"),
("57","27836077","b4cc344d25a2efe540adbf2678e2304c","1457273202","197.211.1.154","SUCCESSFUL"),
("58","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457275076","105.52.123.211","SUCCESSFUL"),
("59","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457276056","105.52.123.211","SUCCESSFUL"),
("60","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457296181","41.81.136.160","SUCCESSFUL"),
("61","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457298394","41.81.136.160","SUCCESSFUL"),
("62","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457299151","41.81.136.160","SUCCESSFUL"),
("63","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457299480","41.81.136.160","SUCCESSFUL"),
("64","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457299499","41.81.136.160","SUCCESSFUL"),
("65","27842875","2154f28665b529473f56a08e79568ab3","1457327783","41.206.45.78","SUCCESSFUL"),
("66","","84753b99151a82da689d219bd65ae7a5","1457331731","41.206.45.78","WRONG_ID_NO"),
("67","27842875","84753b99151a82da689d219bd65ae7a5","1457331741","41.206.45.78","SUCCESSFUL"),
("68","27203610","027e4180beedb29744413a7ea6b84a42","1457331744","197.248.170.154","SUCCESSFUL"),
("69","28346023","684c851af59965b680086b7b4896ff98","1457334063","154.76.80.167","SUCCESSFUL"),
("70","27347637","7daacea5f373b4c1c054158b126d317f","1457335103","197.237.245.31","SUCCESSFUL"),
("71","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457335535","197.232.39.101","SUCCESSFUL"),
("72","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457339376","197.232.39.101","SUCCESSFUL"),
("73","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457350259","197.232.39.101","SUCCESSFUL"),
("74","25931846","c93cae678ac9aca52fe6289f725f937a","1457353639","196.97.115.120","SUCCESSFUL"),
("75","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457358206","197.232.39.101","SUCCESSFUL"),
("76","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457423869","197.232.39.101","SUCCESSFUL"),
("77","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457427055","197.232.39.101","SUCCESSFUL"),
("78","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457435420","197.220.114.2","SUCCESSFUL"),
("79","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457445328","41.90.255.8","SUCCESSFUL"),
("80","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457445697","197.220.114.2","SUCCESSFUL"),
("81","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457446074","197.220.114.2","SUCCESSFUL"),
("82","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457446097","197.220.114.2","SUCCESSFUL"),
("83","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457446751","197.232.39.101","SUCCESSFUL"),
("84","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457446900","197.232.39.101","SUCCESSFUL"),
("85","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457449619","197.211.1.154","SUCCESSFUL"),
("86","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457508482","197.232.39.101","SUCCESSFUL"),
("87","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457511769","197.232.39.101","SUCCESSFUL"),
("88","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457538444","197.232.39.101","SUCCESSFUL"),
("89","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457538772","197.232.39.101","SUCCESSFUL"),
("90","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457585101","197.182.152.69","SUCCESSFUL"),
("91","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457597639","197.232.39.101","SUCCESSFUL"),
("92","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457604035","197.232.39.101","SUCCESSFUL"),
("93","26493976","5f4dcc3b5aa765d61d8327deb882cf99","1457617838","197.232.39.101","SUCCESSFUL"),
("94","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457621870","197.232.39.101","SUCCESSFUL"),
("95","28346023","684c851af59965b680086b7b4896ff98","1457636764","154.76.93.160","SUCCESSFUL"),
("96","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457639197","196.201.221.131","SUCCESSFUL"),
("97","27203610","027e4180beedb29744413a7ea6b84a42","1457683378","197.248.170.154","SUCCESSFUL"),
("98","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457691146","197.232.39.101","SUCCESSFUL"),
("99","tt","d41d8cd98f00b204e9800998ecf8427e","1457694787","197.232.39.101","WRONG_ID_NO"),
("100","27836077","9baa8cb9a7dc08516d03d37fc2f0c8bb","1457697738","197.232.39.101","WRONG_PASSWORD");
INSERT INTO login_history VALUES
("101","27836077","9954b51712813877b30d1e5947b30635","1457697767","197.232.39.101","SUCCESSFUL"),
("102","27842875","84753b99151a82da689d219bd65ae7a5","1457704379","41.206.45.78","SUCCESSFUL"),
("103","27842875","84753b99151a82da689d219bd65ae7a5","1457705003","41.206.45.78","SUCCESSFUL"),
("104","26493976","0e3271c47bf6dcb696e3b0ebcf169ee3","1457711823","197.232.39.101","SUCCESSFUL"),
("105","27836077","6848ba5d9b7eaf1d70ebff4e73b7d078","1457716331","197.211.1.154","SUCCESSFUL"),
("106","26493976","c5af1ebad2d9cb6b40aeb851fc80162c","1457910413","196.99.196.195","SUCCESSFUL");




CREATE TABLE `menu` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(20) NOT NULL,
  `location` varchar(20) NOT NULL,
  `position` int(2) NOT NULL,
  `font_awesome_icon` varchar(50) NOT NULL,
  `data_parent` varchar(20) NOT NULL,
  `css_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;


INSERT INTO menu VALUES
("1","User Management","left","1","fa fa-user","MainMenu","user_management"),
("2","Payments","left","2","fa fa-dollar","MainMenu","payments"),
("3","Loans","left","3","fa fa-table","MainMenu","loans"),
("4","Reports","left","4","fa fa-bar-chart","MainMenu","reports"),
("5","Communication","left","5","fa fa-envelope","MainMenu","communication"),
("6","Expenditure","left","6","fa fa-th-large","MainMenu","expenditure"),
("7","Dividends","left","7","fa fa-share-alt","MainMenu","dividends"),
("8","Permissions","left","8","fa fa-edit","MainMenu","permissions"),
("9","Penalties","left","9","fa fa-pinterest-p","MainMenu","penalties");




CREATE TABLE `menu_access_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `date_time` int(15) NOT NULL,
  `ip_address` varchar(30) NOT NULL,
  `url` varchar(100) NOT NULL,
  `type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;


INSERT INTO menu_access_logs VALUES
("1","6","1457016171","197.232.39.101","/user_management/edit_profile/7","unauthorised access"),
("2","6","1457194248","105.50.89.194","/user_management/user_profile/7","unauthorised access"),
("3","6","1457194274","105.50.89.194","/user_management/edit_profile/7","unauthorised access"),
("4","10","1457221690","105.163.163.109","/user_management/user_profile/1","unauthorised access");




CREATE TABLE `menu_control` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `menu` int(3) NOT NULL,
  `sub_menu` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;


INSERT INTO menu_control VALUES
("1","1","1","13,14,15,22"),
("2","1","2","23"),
("3","1","8","20,21,24"),
("4","2","1","1,2"),
("5","2","2","9"),
("6","2","8","21"),
("7","3","1","11,12"),
("8","3","2","10"),
("9","3","4","25,26"),
("10","4","1","11,12"),
("11","4","2","10"),
("12","4","4","25,26"),
("13","5","1","11,12"),
("14","5","2","10"),
("15","5","4","25,26"),
("16","6","1","11,12"),
("17","6","2","10"),
("18","6","4","25,26"),
("19","7","1","11,12"),
("20","7","2","10"),
("21","7","4","25,26"),
("22","8","1","11,12"),
("23","8","2","10"),
("24","8","4","25,26"),
("25","9","1","11,12"),
("26","9","2","10"),
("27","9","4","25,26"),
("28","10","1","1,2"),
("29","10","2","9,10"),
("30","10","8","20,21,24"),
("31","10","4","25,26"),
("33","2","4","25,26"),
("34","10","9","27,29"),
("37","10","6","30,32"),
("38","6","9","29"),
("39","4","9","29"),
("40","2","9","27,29"),
("41","3","9","29"),
("42","5","9","29"),
("43","7","9","29"),
("44","8","9","29"),
("45","9","9","29"),
("46","2","6","30,32"),
("47","3","6","32"),
("48","4","6","32"),
("49","5","6","32"),
("50","6","6","32"),
("51","7","6","32"),
("52","8","6","32"),
("53","9","6","32");




CREATE TABLE `menu_permissions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_type` int(2) NOT NULL,
  `parent_id` int(2) NOT NULL,
  `visibility_status` tinyint(1) NOT NULL,
  `submenu_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1;


INSERT INTO menu_permissions VALUES
("1","1","1","1","13,14,15,22"),
("2","2","1","1","1,2,3,4"),
("3","3","1","1","1,2,4"),
("4","4","1","1","11,12"),
("5","1","2","1","23"),
("6","2","2","1","9,10,17,18,19"),
("7","3","2","1","9,10,17,18"),
("8","4","2","1","10,16,17"),
("9","1","3","0",""),
("10","2","3","1","5,6,7"),
("11","3","3","1","5,6,7"),
("12","4","3","1","5,7"),
("13","1","4","0",""),
("14","2","4","0",""),
("15","3","4","0",""),
("16","4","4","0",""),
("17","1","5","0",""),
("18","2","5","0",""),
("19","3","5","0",""),
("20","4","5","0",""),
("21","1","6","0",""),
("22","2","6","0",""),
("23","3","6","0",""),
("24","4","6","0",""),
("25","1","7","0",""),
("26","2","7","0",""),
("27","3","7","0",""),
("28","4","7","0",""),
("29","1","8","1","20,21"),
("30","2","8","1","20,21"),
("31","3","8","1","20,21");




CREATE TABLE `next_of_kin` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `first_name` varchar(20) NOT NULL,
  `other_names` varchar(20) NOT NULL,
  `relationship` varchar(20) NOT NULL,
  `phone_no` varchar(15) NOT NULL,
  `added_by` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `next_of_kin_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `password_reset` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `national_id_no` int(10) DEFAULT NULL,
  `time_date` int(15) NOT NULL,
  `ip_address` varchar(30) DEFAULT NULL,
  `old_password` varchar(50) DEFAULT NULL,
  `new_password` varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;


INSERT INTO password_reset VALUES
("1","10","","1457193185","105.50.89.194","ef6e65efc188e7dffd7335b646a85a21","0e3271c47bf6dcb696e3b0ebcf169ee3","user reset"),
("2","2","","1457273246","197.211.1.154","b4cc344d25a2efe540adbf2678e2304c","6848ba5d9b7eaf1d70ebff4e73b7d078","user reset"),
("3","3","","1457327833","41.206.45.78","2154f28665b529473f56a08e79568ab3","84753b99151a82da689d219bd65ae7a5","user reset");




CREATE TABLE `payment_items` (
  `payment_id` int(3) NOT NULL AUTO_INCREMENT,
  `pay_type` varchar(50) NOT NULL,
  `amount` int(10) DEFAULT NULL,
  `status` tinyint(2) NOT NULL,
  `recur` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;


INSERT INTO payment_items VALUES
("1","Registration Fee","200","1","0"),
("2","Share capital","","0","1"),
("3","Service charge","50","0","1"),
("4","Loan repayment","","0","1"),
("5","Loan interest","","0","1"),
("6","Withdrawal fee","300","0","0"),
("7","loan default penalty","50","0","1"),
("8","unpaid monthly contribution penalty","20","0","1");




CREATE TABLE `payments` (
  `transaction_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `reg_fee` int(20) NOT NULL DEFAULT '0',
  `share_capital` int(20) NOT NULL DEFAULT '0',
  `service_charge` int(20) NOT NULL DEFAULT '0',
  `loan_repay` int(20) NOT NULL DEFAULT '0',
  `interest` int(20) NOT NULL DEFAULT '0',
  `loan_penalty` int(20) NOT NULL DEFAULT '0',
  `default_penalty` int(20) NOT NULL DEFAULT '0',
  `withdrawal_fee` int(20) NOT NULL DEFAULT '0',
  `total` int(20) NOT NULL DEFAULT '0',
  `date_time` bigint(20) NOT NULL,
  `time_recorded` int(10) NOT NULL,
  `authorisor` varchar(20) NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `member_no` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=latin1;


INSERT INTO payments VALUES
("1","3","0","500","0","0","0","0","0","0","500","1392411600","1455549525","10"),
("2","4","0","500","0","0","0","0","0","0","500","1392411600","1455549587","10"),
("3","5","0","500","0","0","0","0","0","0","500","1392411600","1455551636","10"),
("4","6","0","500","0","0","0","0","0","0","500","1392411600","1455551648","10"),
("5","7","0","500","0","0","0","0","0","0","500","1392411600","1455551656","10"),
("6","8","0","500","0","0","0","0","0","0","500","1392411600","1455551665","10"),
("7","9","0","500","0","0","0","0","0","0","500","1392411600","1455551673","10"),
("8","3","0","500","0","0","0","0","0","0","500","1394830800","1455552095","10"),
("9","4","0","500","0","0","0","0","0","0","500","1394830800","1455552261","10"),
("10","5","0","500","0","0","0","0","0","0","500","1394830800","1455552270","10"),
("11","6","0","500","0","0","0","0","0","0","500","1394830800","1455552276","10"),
("12","7","0","500","0","0","0","0","0","0","500","1394830800","1455552280","10"),
("13","8","0","500","0","0","0","0","0","0","500","1394830800","1455552285","10"),
("14","9","0","500","0","0","0","0","0","0","500","1394830800","1455552290","10"),
("15","3","0","500","0","0","0","0","0","0","500","1397509200","1455552373","10"),
("16","4","0","500","0","0","0","0","0","0","500","1397509200","1455552377","10"),
("17","5","0","500","0","0","0","0","0","0","500","1397509200","1455552382","10"),
("18","6","0","500","0","0","0","0","0","0","500","1397509200","1455552385","10"),
("19","7","0","500","0","0","0","0","0","0","500","1397509200","1455552389","10"),
("20","8","0","500","0","0","0","0","0","0","500","1397509200","1455552393","10"),
("21","9","0","500","0","0","0","0","0","0","500","1397509200","1455552401","10"),
("22","3","0","500","0","0","0","0","0","0","500","1400101200","1455552473","10"),
("23","4","0","500","0","0","0","0","0","0","500","1400101200","1455552477","10"),
("24","5","0","500","0","0","0","0","0","0","500","1400101200","1455552483","10"),
("25","6","0","500","0","0","0","0","0","0","500","1400101200","1455552487","10"),
("26","7","0","500","0","0","0","0","0","0","500","1400101200","1455552494","10"),
("27","8","0","500","0","0","0","0","0","0","500","1400101200","1455552499","10"),
("28","9","0","500","0","0","0","0","0","0","500","1400101200","1455552503","10"),
("29","3","0","1000","0","0","0","0","0","0","1000","1402779600","1455552661","10"),
("30","4","0","1000","0","0","0","0","0","0","1000","1402779600","1455552665","10"),
("31","5","0","1000","0","0","0","0","0","0","1000","1402779600","1455552669","10"),
("32","6","0","1000","0","0","0","0","0","0","1000","1402779600","1455552674","10"),
("33","7","0","1000","0","0","0","0","0","0","1000","1402779600","1455552687","10"),
("34","8","0","1000","0","0","0","0","0","0","1000","1402779600","1455552691","10"),
("35","9","0","1000","0","0","0","0","0","0","1000","1402779600","1455552697","10"),
("36","3","0","1000","0","0","0","0","0","0","1000","1405371600","1455552987","10"),
("37","4","0","1000","0","0","0","0","0","0","1000","1405371600","1455552990","10"),
("38","5","0","1000","0","0","0","0","0","0","1000","1405371600","1455553002","10"),
("39","6","0","1000","0","0","0","0","0","0","1000","1405371600","1455553009","10"),
("40","7","0","1200","0","0","0","0","0","0","1200","1405371600","1455553019","10"),
("41","8","0","1000","0","0","0","0","0","0","1000","1405371600","1455553024","10"),
("42","9","0","1000","0","0","0","0","0","0","1000","1405371600","1455553028","10"),
("43","3","0","1000","0","0","0","0","0","0","1000","1408050000","1455553088","10"),
("44","4","0","1000","0","0","0","0","0","0","1000","1408050000","1455553093","10"),
("45","5","0","1000","0","0","0","0","0","0","1000","1408050000","1455553097","10"),
("46","6","0","1000","0","0","0","0","0","0","1000","1408050000","1455553103","10"),
("47","7","0","1000","0","0","0","0","0","0","1000","1408050000","1455553106","10"),
("48","8","0","1000","0","0","0","0","0","0","1000","1408050000","1455553109","10"),
("49","9","0","1000","0","0","0","0","0","0","1000","1408050000","1455553113","10"),
("50","3","0","1000","0","0","0","0","0","0","1000","1410728400","1455702444","10"),
("51","4","0","1000","0","0","0","0","0","0","1000","1410728400","1455702448","10"),
("52","5","0","1000","0","0","0","0","0","0","1000","1410728400","1455702452","10"),
("53","6","0","1000","0","0","0","0","0","0","1000","1410728400","1455702457","10"),
("54","7","0","1000","0","0","0","0","0","0","1000","1410728400","1455702463","10"),
("55","8","0","1000","0","0","0","0","0","0","1000","1410728400","1455702468","10"),
("56","9","0","1000","0","0","0","0","0","0","1000","1410728400","1455702472","10"),
("57","3","0","1000","0","0","0","0","0","0","1000","1413320400","1455702799","10"),
("58","4","0","1000","0","0","0","0","0","0","1000","1413320400","1455702803","10"),
("59","5","0","1000","0","0","0","0","0","0","1000","1413320400","1455702808","10"),
("60","6","0","1000","0","0","0","0","0","0","1000","1413320400","1455702812","10"),
("61","7","0","1000","0","0","0","0","0","0","1000","1413320400","1455702838","10"),
("62","8","0","1000","0","0","0","0","0","0","1000","1413320400","1455702841","10"),
("63","9","0","1000","0","0","0","0","0","0","1000","1413320400","1455702846","10"),
("64","3","0","1000","0","0","0","0","0","0","1000","1415998800","1455702995","10"),
("65","4","0","1000","0","0","0","0","0","0","1000","1415998800","1455702999","10"),
("66","5","0","1000","0","0","0","0","0","0","1000","1415998800","1455703003","10"),
("67","6","0","1000","0","0","0","0","0","0","1000","1415998800","1455703010","10"),
("68","7","0","1000","0","0","0","0","0","0","1000","1415998800","1455703015","10"),
("69","8","0","1000","0","0","0","0","0","0","1000","1415998800","1455703018","10"),
("70","9","0","1000","0","0","0","0","0","0","1000","1415998800","1455703023","10"),
("71","3","0","1000","0","0","0","0","0","0","1000","1418590800","1455703101","10"),
("72","4","0","1000","0","0","0","0","0","0","1000","1418590800","1455703104","10"),
("73","5","0","1000","0","0","0","0","0","0","1000","1418590800","1455703108","10"),
("74","6","0","1000","0","0","0","0","0","0","1000","1418590800","1455703155","10"),
("75","7","0","1000","0","0","0","0","0","0","1000","1418590800","1455703159","10"),
("76","8","0","1000","0","0","0","0","0","0","1000","1418590800","1455703162","10"),
("77","9","0","1000","0","0","0","0","0","0","1000","1418590800","1455703167","10"),
("78","1000000","0","1000","0","0","0","0","0","0","1000","1421269200","1455703373","10"),
("79","4","0","1000","0","0","0","0","0","0","1000","1421269200","1455703378","10"),
("80","5","0","1500","0","0","0","0","0","0","1500","1421269200","1455703389","10"),
("81","6","0","1000","0","0","0","0","0","0","1000","1421269200","1455703393","10"),
("82","7","0","1000","0","0","0","0","0","0","1000","1421269200","1455703397","10"),
("83","8","0","1000","0","0","0","0","0","0","1000","1421269200","1455703403","10"),
("84","9","0","1000","0","0","0","0","0","0","1000","1421269200","1455703412","10"),
("85","3","0","1000","0","0","0","0","0","0","1000","1421269200","1455703479","10"),
("86","4","0","1000","0","0","0","0","0","0","1000","1423947600","1455703484","10"),
("87","5","0","1500","0","0","0","0","0","0","1500","1423947600","1455703494","10"),
("88","3","0","1000","0","0","0","0","0","0","1000","1423947600","1455703551","10"),
("89","6","0","1000","0","0","0","0","0","0","1000","1423947600","1455703610","10"),
("90","7","0","1000","0","0","0","0","0","0","1000","1423947600","1455703614","10"),
("91","8","0","1000","0","0","0","0","0","0","1000","1423947600","1455703619","10"),
("92","9","0","1000","0","0","0","0","0","0","1000","1423947600","1455703624","10"),
("93","3","0","1000","0","0","0","0","0","0","1000","1426366800","1455703731","10"),
("94","4","0","1000","0","0","0","0","0","0","1000","1426366800","1455703734","10"),
("95","5","0","1000","0","0","0","0","0","0","1000","1426366800","1455703742","10"),
("96","6","0","1500","0","0","0","0","0","0","1500","1426366800","1455703750","10"),
("97","7","0","1000","0","0","0","0","0","0","1000","1426366800","1455703759","10"),
("98","8","0","1000","0","0","0","0","0","0","1000","1426366800","1455703763","10"),
("99","9","0","1000","0","0","0","0","0","0","1000","1426366800","1455703767","10"),
("100","3","0","1000","0","0","0","0","0","0","1000","1429045200","1455703831","10");
INSERT INTO payments VALUES
("101","4","0","1000","0","0","0","0","0","0","1000","1429045200","1455703834","10"),
("102","5","0","1000","0","0","0","0","0","0","1000","1429045200","1455703838","10"),
("103","6","0","1500","0","0","0","0","0","0","1500","1429045200","1455703843","10"),
("104","7","0","1000","0","0","0","0","0","0","1000","1429045200","1455703999","10"),
("105","8","0","1000","0","0","0","0","0","0","1000","1429045200","1455704004","10"),
("106","9","0","1000","0","0","0","0","0","0","1000","1429045200","1455704007","10"),
("107","3","0","1500","0","0","0","0","0","0","1500","1431637200","1455719864","10"),
("108","4","0","1000","0","0","0","0","0","0","1000","1431637200","1455719872","10"),
("109","5","0","1500","0","0","0","0","0","0","1500","1431637200","1455719886","10"),
("110","6","0","1500","0","0","0","0","0","0","1500","1431637200","1455719892","10"),
("111","7","0","1000","0","0","0","0","0","0","1000","1431637200","1455719896","10"),
("112","8","0","1000","0","0","0","0","0","0","1000","1431637200","1455719899","10"),
("113","9","0","1000","0","0","0","0","0","0","1000","1431637200","1455719903","10"),
("114","3","0","2000","0","0","0","0","0","0","2000","1434315600","1455720128","10"),
("115","4","0","2000","0","0","0","0","0","0","2000","1434315600","1455720131","10"),
("116","5","0","2000","0","0","0","0","0","0","2000","1434315600","1455720135","10"),
("117","6","0","2000","0","0","0","0","0","0","2000","1434315600","1455720138","10"),
("118","7","0","2000","0","0","0","0","0","0","2000","1434315600","1455720141","10"),
("119","8","0","2000","0","0","0","0","0","0","2000","1434315600","1455720145","10"),
("120","9","0","2000","0","0","0","0","0","0","2000","1434315600","1455720148","10"),
("121","3","0","2000","0","0","0","0","0","0","2000","1436907600","1455720196","10"),
("122","4","0","2000","0","0","0","0","0","0","2000","1436907600","1455720254","10"),
("123","5","0","2000","0","0","0","0","0","0","2000","1436907600","1455720259","10"),
("124","6","0","2000","0","0","0","0","0","0","2000","1436907600","1455720262","10"),
("125","7","0","2000","0","0","0","0","0","0","2000","1436907600","1455720265","10"),
("126","8","0","2000","0","0","0","0","0","0","2000","1436907600","1455720269","10"),
("127","9","0","2000","0","0","0","0","0","0","2000","1436907600","1455720273","10"),
("128","3","0","2000","0","0","0","0","0","0","2000","1439586000","1455720349","10"),
("129","4","0","2000","0","0","0","0","0","0","2000","1439586000","1455720352","10"),
("130","5","0","2000","0","0","0","0","0","0","2000","1439586000","1455720355","10"),
("131","6","0","3000","0","0","0","0","0","0","3000","1439586000","1455720363","10"),
("132","7","0","2000","0","0","0","0","0","0","2000","1439586000","1455720366","10"),
("133","8","0","2000","0","0","0","0","0","0","2000","1439586000","1455720371","10"),
("134","9","0","2000","0","0","0","0","0","0","2000","1439586000","1455720374","10"),
("135","3","0","2000","0","0","0","0","0","0","2000","1442264400","1455720412","10"),
("136","4","0","2000","0","0","0","0","0","0","2000","1442264400","1455720415","10"),
("137","5","0","3000","0","0","0","0","0","0","3000","1442264400","1455720424","10"),
("138","6","0","3000","0","0","0","0","0","0","3000","1442264400","1455720431","10"),
("139","7","0","2000","0","0","0","0","0","0","2000","1442264400","1455720436","10"),
("140","8","0","3000","0","0","0","0","0","0","3000","1442264400","1455720442","10"),
("141","9","0","2000","0","0","0","0","0","0","2000","1442264400","1455720445","10"),
("142","3","0","2500","0","0","0","0","0","0","2500","1444856400","1455720480","10"),
("143","4","0","2000","0","0","0","0","0","0","2000","1444856400","1455720488","10"),
("144","5","0","4000","0","0","0","0","0","0","4000","1444856400","1455720498","10"),
("145","6","0","4500","0","0","0","0","0","0","4500","1444856400","1455720516","10"),
("146","7","0","2000","0","0","0","0","0","0","2000","1444856400","1455720523","10"),
("147","8","0","2000","0","0","0","0","0","0","2000","1444856400","1455720527","10"),
("148","9","0","2000","0","0","0","0","0","0","2000","1444856400","1455720530","10"),
("149","3","0","10000","0","0","0","0","0","0","10000","1447534800","1455720577","10"),
("150","4","0","12000","0","0","0","0","0","0","12000","1447534800","1455722029","10"),
("151","5","0","5000","0","0","0","0","0","0","5000","1447534800","1455722043","10"),
("152","6","0","7000","0","0","0","0","0","0","7000","1447534800","1455722131","10"),
("153","7","0","4800","0","0","0","0","0","0","4800","1447534800","1455722144","10"),
("154","8","0","3000","0","0","0","0","0","0","3000","1447534800","1455722157","10"),
("155","9","0","2000","0","0","0","0","0","0","2000","1447534800","1455722257","10"),
("156","3","0","6000","0","0","0","0","0","0","6000","1450126800","1455722659","10"),
("157","4","0","5000","0","0","0","0","0","0","5000","1450126800","1455722677","10"),
("158","5","0","7500","0","0","0","0","0","0","7500","1450126800","1455722691","10"),
("159","6","0","4000","0","0","0","0","0","0","4000","1450126800","1455722701","10"),
("160","7","0","12000","0","0","0","0","0","0","12000","1450126800","1455722714","10"),
("161","8","0","13000","0","0","0","0","0","0","13000","1450126800","1455722729","10"),
("162","9","0","15000","0","0","0","0","0","0","15000","1450126800","1455722738","10"),
("163","3","0","2000","0","0","0","0","0","0","2000","1452805200","1455722768","10"),
("164","4","0","2000","0","0","0","0","0","0","2000","1452805200","1455722772","10"),
("165","5","0","2000","0","0","0","0","0","0","2000","1452805200","1455722776","10"),
("166","6","0","2000","0","0","0","0","0","0","2000","1452805200","1455722796","10"),
("167","7","0","2000","0","0","0","0","0","0","2000","1452805200","1455722799","10"),
("168","8","0","2000","0","0","0","0","0","0","2000","1452805200","1455722803","10"),
("169","9","0","2000","0","0","0","0","0","0","2000","1452805200","1455722806","10"),
("170","5","0","3000","0","0","0","0","0","0","3000","1454619600","1456763311","2"),
("171","5","0","3000","0","0","0","0","0","0","3000","1457179200","1456765146","2"),
("172","3","0","2000","0","0","0","0","0","0","2000","1456347600","1456765173","2"),
("173","4","0","2000","0","0","0","0","0","0","2000","1456002000","1456765349","2"),
("174","7","0","2000","0","0","0","0","0","0","2000","1456261200","1456765394","2"),
("175","8","0","2000","0","0","0","0","0","0","2000","1456347600","1456765414","2"),
("176","6","0","2000","0","0","0","0","0","0","2000","1454274000","1456765479","2");




CREATE TABLE `payments_log` (
  `payment_log_id` int(10) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `action` varchar(20) NOT NULL,
  `initial_amount` int(10) NOT NULL,
  `updated_amount` int(10) NOT NULL,
  `comment` text NOT NULL,
  `status` int(2) NOT NULL,
  PRIMARY KEY (`payment_log_id`),
  KEY `transaction_id` (`transaction_id`),
  CONSTRAINT `payments_log_ibfk_1` FOREIGN KEY (`transaction_id`) REFERENCES `payments` (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






CREATE TABLE `penalties` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  `reason` varchar(30) NOT NULL,
  `amount` int(10) NOT NULL,
  `status` int(3) NOT NULL,
  `authorisor` int(10) NOT NULL,
  `time_recorded` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;


INSERT INTO penalties VALUES
("1","9","1449867600","Late Payment","1000","0","10","1457297499"),
("2","8","1449867600","Absenteeism","1000","0","10","1457297556"),
("3","5","1449867600","Absenteeism","500","1","10","1457297573"),
("4","9","1456434000","Late Payment","1000","0","10","1457297632"),
("5","9","1434142800","Absenteeism","500","0","2","1457452012");




CREATE TABLE `profile_changes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `photo` varchar(50) DEFAULT NULL,
  `first_name` varchar(30) NOT NULL,
  `other_names` varchar(50) NOT NULL,
  `email_address` varchar(50) NOT NULL,
  `phone_no` varchar(15) NOT NULL,
  `date_time` int(15) NOT NULL,
  `ip_address` varchar(30) NOT NULL,
  `authorisor` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;


INSERT INTO profile_changes VALUES
("1","4","27347637_1457239988.jpg","Dennis","Karani","ngugikarani@gmail.com","+254731044320","1457239988","197.237.245.31","4"),
("2","9","0","Godfrey","Kirimi","gkirimi6@gmail.com","+254723475264","1457353740","196.97.115.120","9");




CREATE TABLE `registration_fee` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;


INSERT INTO registration_fee VALUES
("1","20","25","1","0"),
("2","21","5","10","1442308253"),
("3","25","25","100","1442699616"),
("4","26","25","100","1442699640"),
("5","40","25","454","1442840070"),
("6","41","5","3243","1442841476"),
("7","43","25","44","1442841625"),
("8","44","25","344","1442841881"),
("9","45","25","33","1442842023"),
("10","47","25","212","1442844649"),
("11","49","25","3434","1442845553"),
("12","50","25","3333","1442845765"),
("13","52","25","67","1442846191"),
("14","53","25","232","1442847191"),
("15","54","25","5545","1442847303"),
("16","65","25","200","1442920694"),
("17","83","25","3334","1442926721"),
("18","84","25","89789678","1442927129"),
("19","85","5","9000","1442927459"),
("20","92","25","77","1447924562"),
("21","93","25","44","1447925621"),
("22","94","25","25","1447925672"),
("23","95","5","45","1448650792"),
("24","96","25","500","1449317123");




CREATE TABLE `sub_menu` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `parent_id` int(2) NOT NULL,
  `submenu_name` varchar(30) NOT NULL,
  `position` int(2) NOT NULL,
  `link` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1;


INSERT INTO sub_menu VALUES
("1","1","Member Registration","1","user_management/member_registration"),
("2","1","View Members","2","user_management/view_members"),
("3","1","Add Staff","3","user_management/add_staff"),
("4","1","Upload Members CSV","4","user_management/upload_members_csv"),
("5","3","Loan Application","1","loans/loan_application"),
("6","3","Loan Verification","2","loans/loans_verification"),
("7","3","Loan Calculator","3","loans/loan_calculator"),
("8","3","Loan Repayment","4","loans/loan_repayment"),
("9","2","Process Payment","1","payments/process_payment"),
("10","2","Financial Statement","7","payments/financial_statement"),
("11","1","View Profile","5","user_management/user_profile/subUserId"),
("12","1","Edit Profile","6","user_management/edit_profile/subUserId"),
("13","1","Add Corporation","7","user_management/add_corporation"),
("14","1","Add Admin","8","user_management/add_admin"),
("15","1","View Corporations","9","user_management/view_corporations"),
("16","2","Money Transfer","3","payments/money_transfer"),
("17","2","Split Payment","4","payments/split_payment"),
("18","2","Log Payment Correction","5","payments/log_payment_correction"),
("19","2","Clear Payment Log","6","payments/clear_payment_log"),
("20","8","Menu Control","1","permissions/menu_control"),
("21","8","Account Activation","2","permissions/account_activation"),
("22","1","View Administrators","10","user_management/view_administrators"),
("23","2","License Fee","2","payments/license_fee"),
("24","8","Default Permissions","3","permissions/default_permissions"),
("25","4","Group Financial Report","1","reports/financial_report"),
("26","4","Contributions Per Member","2","reports/contributions_per_member"),
("27","9","Add Penalty","1","penalties/add_penalty"),
("28","9","Update Penalties","2","penalties/update_penalties"),
("29","9","View Penalties","3","penalties/view_penalties"),
("30","6","Add Project","1","expenditure/add_project"),
("31","6","Update Projects","2","expenditure/update_projects"),
("32","6","View Projects","3","expenditure/view_projects");




CREATE TABLE `user_types` (
  `user_type_id` int(2) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) NOT NULL,
  `displayed_user_type` varchar(20) NOT NULL,
  PRIMARY KEY (`user_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;


INSERT INTO user_types VALUES
("1","super_admin","Super Admin"),
("2","admin","Administrator"),
("3","staff","Staff Member"),
("4","member","Account Holder");




CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `member_no` varchar(20) NOT NULL,
  `corporation_id` int(3) NOT NULL,
  `first_name` varchar(20) NOT NULL,
  `other_names` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `phone_no` varchar(15) NOT NULL,
  `national_id_no` int(10) NOT NULL,
  `user_type` tinyint(2) NOT NULL,
  `email_address` varchar(30) NOT NULL,
  `photo` varchar(50) DEFAULT NULL,
  `date_created` bigint(20) NOT NULL,
  `created_by` int(10) NOT NULL,
  `password` varchar(255) NOT NULL,
  `active_status` tinyint(1) NOT NULL,
  `last_login` bigint(20) NOT NULL,
  `last_IP` varchar(20) NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `corporation_id` (`corporation_id`),
  KEY `user_type` (`user_type`),
  CONSTRAINT `users_ibfk_1` FOREIGN KEY (`corporation_id`) REFERENCES `corporations` (`corporation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;


INSERT INTO users VALUES
("1","","1","Thomas","Gacheru Njoroge","Thomas Gacheru Njoroge","+254723897065","26493976","1","thomasnjoroge10@gmail.com","26493976_1435853418.jpg","1435853418","0","5f4dcc3b5aa765d61d8327deb882cf99","1","1457617838","197.232.39.101"),
("2","","2","James","Kariu Macharia","James Kariu Macharia","+254728617714","27836077","2","macharia.jimmo@gmail.com","default_image.jpg","1455548316","1","6848ba5d9b7eaf1d70ebff4e73b7d078","1","1457716521","197.211.1.154"),
("3","001","2","Dickson","Njuki","Dickson Njuki","+254716701155","27842875","4","dickson.njuki@gmail.com","default_image.jpg","1455548909","2","84753b99151a82da689d219bd65ae7a5","1","1457705003","41.206.45.78"),
("4","002","2","Dennis","Karani","Dennis Karani","+254731044320","27347637","4","ngugikarani@gmail.com","27347637_1457239988.jpg","1455548965","2","7daacea5f373b4c1c054158b126d317f","1","1457335103","197.237.245.31"),
("5","003","2","James","Kariu","James Kariu","+254728617714","27836077","4","macharia.jimmo@gmail.com","default_image.jpg","1455549034","2","b4cc344d25a2efe540adbf2678e2304c","1","1457697769","197.232.39.101"),
("6","004","2","Thomas","Gacheru Njoroge","Thomas Gacheru Njoroge","+254723897065","26493976","4","thomasnjoroge10@gmail.com","26493976_1455549160.jpg","1455549160","2","c5af1ebad2d9cb6b40aeb851fc80162c","1","1457910413","196.99.196.195"),
("7","005","2","Robert","Mohe","Robert Mohe","+254723875940","28346023","4","robertmohe09@gmail.com","default_image.jpg","1455549277","2","684c851af59965b680086b7b4896ff98","1","1457636913","154.76.93.160"),
("8","006","2","Henry","Kamiti Kihara","Henry Kamiti Kihara","+254720086686","27203610","4","henrykamiti@gmail.com","default_image.jpg","1455549318","2","027e4180beedb29744413a7ea6b84a42","1","1457683378","197.248.170.154"),
("9","007","2","Godfrey","Kirimi","Godfrey Kirimi","+254723475264","25931846","4","gkirimi6@gmail.com","0","1455549392","2","c93cae678ac9aca52fe6289f725f937a","1","1457354495","196.97.115.120"),
("10","","2","Thomas","Gacheru Njoroge","Thomas Gacheru Njoroge","+254723897065","26493976","2","thomasnjoroge10@gmail.com","26493976_1457193318.jpg","1455551839","1","0e3271c47bf6dcb696e3b0ebcf169ee3","1","1457711823","197.232.39.101");




CREATE TABLE `withdrawal` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `amount` int(10) NOT NULL,
  `date_time` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;


INSERT INTO withdrawal VALUES
("1","20","25","8","0"),
("2","21","5","90","1442308253"),
("3","51","25","5677","1442845917"),
("4","61","25","400","1442920033"),
("5","62","25","400","1442920123"),
("6","63","25","400","1442920538"),
("7","64","25","400","1442920629");


